@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Documentation].
 */
@PulumiTagMarker
public class DocumentationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DocumentationArgs = DocumentationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DocumentationArgsBuilder.() -> Unit) {
        val builder = DocumentationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Documentation {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.Documentation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Documentation(builtJavaResource)
    }
}

/**
 * Markdown documentation details.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateDocumentation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var documentation = new AzureNative.ApiManagement.Documentation("documentation", new()
 *     {
 *         Content = "content",
 *         DocumentationId = "57d1f7558aa04f15146d9d8a",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Title = "Title",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewDocumentation(ctx, "documentation", &apimanagement.DocumentationArgs{
 * 			Content:           pulumi.String("content"),
 * 			DocumentationId:   pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Title:             pulumi.String("Title"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Documentation;
 * import com.pulumi.azurenative.apimanagement.DocumentationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var documentation = new Documentation("documentation", DocumentationArgs.builder()
 *             .content("content")
 *             .documentationId("57d1f7558aa04f15146d9d8a")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .title("Title")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Documentation 57d1f7558aa04f15146d9d8a /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/documentations/{documentationId}
 * ```
 */
public class Documentation internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.Documentation,
) : KotlinCustomResource(javaResource, DocumentationMapper) {
    /**
     * Markdown documentation content.
     */
    public val content: Output<String>?
        get() = javaResource.content().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * documentation title.
     */
    public val title: Output<String>?
        get() = javaResource.title().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DocumentationMapper : ResourceMapper<Documentation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.Documentation::class == javaResource::class

    override fun map(javaResource: Resource): Documentation = Documentation(
        javaResource as
            com.pulumi.azurenative.apimanagement.Documentation,
    )
}

/**
 * @see [Documentation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Documentation].
 */
public suspend fun documentation(
    name: String,
    block: suspend DocumentationResourceBuilder.() -> Unit,
): Documentation {
    val builder = DocumentationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Documentation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun documentation(name: String): Documentation {
    val builder = DocumentationResourceBuilder()
    builder.name(name)
    return builder.build()
}
