@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.GatewayHostnameConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gateway hostname configuration details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGatewayHostnameConfiguration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gatewayHostnameConfiguration = new AzureNative.ApiManagement.GatewayHostnameConfiguration("gatewayHostnameConfiguration", new()
 *     {
 *         CertificateId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1",
 *         GatewayId = "gw1",
 *         HcId = "default",
 *         Hostname = "*",
 *         Http2Enabled = true,
 *         NegotiateClientCertificate = false,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Tls10Enabled = false,
 *         Tls11Enabled = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGatewayHostnameConfiguration(ctx, "gatewayHostnameConfiguration", &apimanagement.GatewayHostnameConfigurationArgs{
 * 			CertificateId:              pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1"),
 * 			GatewayId:                  pulumi.String("gw1"),
 * 			HcId:                       pulumi.String("default"),
 * 			Hostname:                   pulumi.String("*"),
 * 			Http2Enabled:               pulumi.Bool(true),
 * 			NegotiateClientCertificate: pulumi.Bool(false),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			ServiceName:                pulumi.String("apimService1"),
 * 			Tls10Enabled:               pulumi.Bool(false),
 * 			Tls11Enabled:               pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GatewayHostnameConfiguration;
 * import com.pulumi.azurenative.apimanagement.GatewayHostnameConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gatewayHostnameConfiguration = new GatewayHostnameConfiguration("gatewayHostnameConfiguration", GatewayHostnameConfigurationArgs.builder()
 *             .certificateId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1")
 *             .gatewayId("gw1")
 *             .hcId("default")
 *             .hostname("*")
 *             .http2Enabled(true)
 *             .negotiateClientCertificate(false)
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tls10Enabled(false)
 *             .tls11Enabled(false)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GatewayHostnameConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/gateways/{gatewayId}/hostnameConfigurations/{hcId}
 * ```
 * @property certificateId Identifier of Certificate entity that will be used for TLS connection establishment
 * @property gatewayId Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
 * @property hcId Gateway hostname configuration identifier. Must be unique in the scope of parent Gateway entity.
 * @property hostname Hostname value. Supports valid domain name, partial or full wildcard
 * @property http2Enabled Specifies if HTTP/2.0 is supported
 * @property negotiateClientCertificate Determines whether gateway requests client certificate
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tls10Enabled Specifies if TLS 1.0 is supported
 * @property tls11Enabled Specifies if TLS 1.1 is supported
 */
public data class GatewayHostnameConfigurationArgs(
    public val certificateId: Output<String>? = null,
    public val gatewayId: Output<String>? = null,
    public val hcId: Output<String>? = null,
    public val hostname: Output<String>? = null,
    public val http2Enabled: Output<Boolean>? = null,
    public val negotiateClientCertificate: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tls10Enabled: Output<Boolean>? = null,
    public val tls11Enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.GatewayHostnameConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.GatewayHostnameConfigurationArgs =
        com.pulumi.azurenative.apimanagement.GatewayHostnameConfigurationArgs.builder()
            .certificateId(certificateId?.applyValue({ args0 -> args0 }))
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .hcId(hcId?.applyValue({ args0 -> args0 }))
            .hostname(hostname?.applyValue({ args0 -> args0 }))
            .http2Enabled(http2Enabled?.applyValue({ args0 -> args0 }))
            .negotiateClientCertificate(negotiateClientCertificate?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tls10Enabled(tls10Enabled?.applyValue({ args0 -> args0 }))
            .tls11Enabled(tls11Enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayHostnameConfigurationArgs].
 */
@PulumiTagMarker
public class GatewayHostnameConfigurationArgsBuilder internal constructor() {
    private var certificateId: Output<String>? = null

    private var gatewayId: Output<String>? = null

    private var hcId: Output<String>? = null

    private var hostname: Output<String>? = null

    private var http2Enabled: Output<Boolean>? = null

    private var negotiateClientCertificate: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tls10Enabled: Output<Boolean>? = null

    private var tls11Enabled: Output<Boolean>? = null

    /**
     * @param value Identifier of Certificate entity that will be used for TLS connection establishment
     */
    @JvmName("tmipetvoxhlxrrmy")
    public suspend fun certificateId(`value`: Output<String>) {
        this.certificateId = value
    }

    /**
     * @param value Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     */
    @JvmName("obgidtqnxspcrvlq")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value Gateway hostname configuration identifier. Must be unique in the scope of parent Gateway entity.
     */
    @JvmName("sxxtwutotjxbwuef")
    public suspend fun hcId(`value`: Output<String>) {
        this.hcId = value
    }

    /**
     * @param value Hostname value. Supports valid domain name, partial or full wildcard
     */
    @JvmName("feqbglwjpvwtbfca")
    public suspend fun hostname(`value`: Output<String>) {
        this.hostname = value
    }

    /**
     * @param value Specifies if HTTP/2.0 is supported
     */
    @JvmName("hyafrykrsumavyql")
    public suspend fun http2Enabled(`value`: Output<Boolean>) {
        this.http2Enabled = value
    }

    /**
     * @param value Determines whether gateway requests client certificate
     */
    @JvmName("vrbupmjeswgrrpcx")
    public suspend fun negotiateClientCertificate(`value`: Output<Boolean>) {
        this.negotiateClientCertificate = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mewjycbugukwafgf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vlnapmgocksgpqfn")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Specifies if TLS 1.0 is supported
     */
    @JvmName("bcfhxadqisxfkwpr")
    public suspend fun tls10Enabled(`value`: Output<Boolean>) {
        this.tls10Enabled = value
    }

    /**
     * @param value Specifies if TLS 1.1 is supported
     */
    @JvmName("wjoxumfbsgwfnxgf")
    public suspend fun tls11Enabled(`value`: Output<Boolean>) {
        this.tls11Enabled = value
    }

    /**
     * @param value Identifier of Certificate entity that will be used for TLS connection establishment
     */
    @JvmName("gvcqddmisfgivbxs")
    public suspend fun certificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateId = mapped
    }

    /**
     * @param value Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     */
    @JvmName("bdstyxxafkyhfaxi")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value Gateway hostname configuration identifier. Must be unique in the scope of parent Gateway entity.
     */
    @JvmName("dhsycctdopcnsyea")
    public suspend fun hcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hcId = mapped
    }

    /**
     * @param value Hostname value. Supports valid domain name, partial or full wildcard
     */
    @JvmName("howkpoibgurnxpao")
    public suspend fun hostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param value Specifies if HTTP/2.0 is supported
     */
    @JvmName("yevbnxnfijuvqqyq")
    public suspend fun http2Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2Enabled = mapped
    }

    /**
     * @param value Determines whether gateway requests client certificate
     */
    @JvmName("bifppedqyyitnowv")
    public suspend fun negotiateClientCertificate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negotiateClientCertificate = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hockvlopfumhtesx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("aoyarequkdkaipoa")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Specifies if TLS 1.0 is supported
     */
    @JvmName("yrrfapoidhsruwne")
    public suspend fun tls10Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls10Enabled = mapped
    }

    /**
     * @param value Specifies if TLS 1.1 is supported
     */
    @JvmName("rxcdyhnykkvfvscl")
    public suspend fun tls11Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls11Enabled = mapped
    }

    internal fun build(): GatewayHostnameConfigurationArgs = GatewayHostnameConfigurationArgs(
        certificateId = certificateId,
        gatewayId = gatewayId,
        hcId = hcId,
        hostname = hostname,
        http2Enabled = http2Enabled,
        negotiateClientCertificate = negotiateClientCertificate,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        tls10Enabled = tls10Enabled,
        tls11Enabled = tls11Enabled,
    )
}
