@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GraphQLApiResolverPolicy].
 */
@PulumiTagMarker
public class GraphQLApiResolverPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GraphQLApiResolverPolicyArgs = GraphQLApiResolverPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GraphQLApiResolverPolicyArgsBuilder.() -> Unit) {
        val builder = GraphQLApiResolverPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GraphQLApiResolverPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GraphQLApiResolverPolicy(builtJavaResource)
    }
}

/**
 * Policy Contract details.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGraphQLApiResolverPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var graphQLApiResolverPolicy = new AzureNative.ApiManagement.GraphQLApiResolverPolicy("graphQLApiResolverPolicy", new()
 *     {
 *         ApiId = "5600b57e7e8880006a040001",
 *         Format = AzureNative.ApiManagement.PolicyContentFormat.Xml,
 *         PolicyId = "policy",
 *         ResolverId = "5600b57e7e8880006a080001",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "<http-data-source><http-request><set-method>GET</set-method><set-backend-service base-url=\"https://some.service.com\" /><set-url>/api/users</set-url></http-request></http-data-source>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGraphQLApiResolverPolicy(ctx, "graphQLApiResolverPolicy", &apimanagement.GraphQLApiResolverPolicyArgs{
 * 			ApiId:             pulumi.String("5600b57e7e8880006a040001"),
 * 			Format:            pulumi.String(apimanagement.PolicyContentFormatXml),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ResolverId:        pulumi.String("5600b57e7e8880006a080001"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("<http-data-source><http-request><set-method>GET</set-method><set-backend-service base-url=\"https://some.service.com\" /><set-url>/api/users</set-url></http-request></http-data-source>"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicy;
 * import com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var graphQLApiResolverPolicy = new GraphQLApiResolverPolicy("graphQLApiResolverPolicy", GraphQLApiResolverPolicyArgs.builder()
 *             .apiId("5600b57e7e8880006a040001")
 *             .format("xml")
 *             .policyId("policy")
 *             .resolverId("5600b57e7e8880006a080001")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("<http-data-source><http-request><set-method>GET</set-method><set-backend-service base-url=\"https://some.service.com\" /><set-url>/api/users</set-url></http-request></http-data-source>")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GraphQLApiResolverPolicy policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/resolvers/{resolverId}/policies/{policyId}
 * ```
 */
public class GraphQLApiResolverPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicy,
) : KotlinCustomResource(javaResource, GraphQLApiResolverPolicyMapper) {
    /**
     * Format of the policyContent.
     */
    public val format: Output<String>?
        get() = javaResource.format().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Contents of the Policy as defined by the format.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object GraphQLApiResolverPolicyMapper : ResourceMapper<GraphQLApiResolverPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicy::class == javaResource::class

    override fun map(javaResource: Resource): GraphQLApiResolverPolicy =
        GraphQLApiResolverPolicy(
            javaResource as
                com.pulumi.azurenative.apimanagement.GraphQLApiResolverPolicy,
        )
}

/**
 * @see [GraphQLApiResolverPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GraphQLApiResolverPolicy].
 */
public suspend fun graphQLApiResolverPolicy(
    name: String,
    block: suspend GraphQLApiResolverPolicyResourceBuilder.() -> Unit,
): GraphQLApiResolverPolicy {
    val builder = GraphQLApiResolverPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GraphQLApiResolverPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun graphQLApiResolverPolicy(name: String): GraphQLApiResolverPolicy {
    val builder = GraphQLApiResolverPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
