@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.GroupUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2017-03-01, 2018-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGroupUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var groupUser = new AzureNative.ApiManagement.GroupUser("groupUser", new()
 *     {
 *         GroupId = "tempgroup",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         UserId = "59307d350af58404d8a26300",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGroupUser(ctx, "groupUser", &apimanagement.GroupUserArgs{
 * 			GroupId:           pulumi.String("tempgroup"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			UserId:            pulumi.String("59307d350af58404d8a26300"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GroupUser;
 * import com.pulumi.azurenative.apimanagement.GroupUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var groupUser = new GroupUser("groupUser", GroupUserArgs.builder()
 *             .groupId("tempgroup")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .userId("59307d350af58404d8a26300")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GroupUser 59307d350af58404d8a26300 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/groups/{groupId}/users/{userId}
 * ```
 * @property groupId Group identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property userId User identifier. Must be unique in the current API Management service instance.
 */
public data class GroupUserArgs(
    public val groupId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val userId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.GroupUserArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.GroupUserArgs =
        com.pulumi.azurenative.apimanagement.GroupUserArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupUserArgs].
 */
@PulumiTagMarker
public class GroupUserArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var userId: Output<String>? = null

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("llyjsyktlwmrfuas")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qtvvexohknqkmuvs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ptuijlnkxfpeiqwi")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value User identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("mjnpvijmuyutlcub")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("bwotincnrkjltsmx")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ojoaiieqknllsagg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("jdbemdluckspcnbl")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value User identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("njcquipyrfupuxsb")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): GroupUserArgs = GroupUserArgs(
        groupId = groupId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        userId = userId,
    )
}
