@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.IdentityProviderArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.IdentityProviderType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Identity Provider details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2019-01-01, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateIdentityProvider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var identityProvider = new AzureNative.ApiManagement.IdentityProvider("identityProvider", new()
 *     {
 *         ClientId = "facebookid",
 *         ClientSecret = "facebookapplicationsecret",
 *         IdentityProviderName = "facebook",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewIdentityProvider(ctx, "identityProvider", &apimanagement.IdentityProviderArgs{
 * 			ClientId:             pulumi.String("facebookid"),
 * 			ClientSecret:         pulumi.String("facebookapplicationsecret"),
 * 			IdentityProviderName: pulumi.String("facebook"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 			ServiceName:          pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.IdentityProvider;
 * import com.pulumi.azurenative.apimanagement.IdentityProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var identityProvider = new IdentityProvider("identityProvider", IdentityProviderArgs.builder()
 *             .clientId("facebookid")
 *             .clientSecret("facebookapplicationsecret")
 *             .identityProviderName("facebook")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:IdentityProvider Facebook /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/identityProviders/{identityProviderName}
 * ```
 * @property allowedTenants List of Allowed Tenants when configuring Azure Active Directory login.
 * @property authority OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
 * @property clientId Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
 * @property clientLibrary The client library to be used in the developer portal. Only applies to AAD and AAD B2C Identity Provider.
 * @property clientSecret Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
 * @property identityProviderName Identity Provider Type identifier.
 * @property passwordResetPolicyName Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
 * @property profileEditingPolicyName Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property signinPolicyName Signin Policy Name. Only applies to AAD B2C Identity Provider.
 * @property signinTenant The TenantId to use instead of Common when logging into Active Directory
 * @property signupPolicyName Signup Policy Name. Only applies to AAD B2C Identity Provider.
 * @property type Identity Provider Type identifier.
 */
public data class IdentityProviderArgs(
    public val allowedTenants: Output<List<String>>? = null,
    public val authority: Output<String>? = null,
    public val clientId: Output<String>? = null,
    public val clientLibrary: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val identityProviderName: Output<String>? = null,
    public val passwordResetPolicyName: Output<String>? = null,
    public val profileEditingPolicyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val signinPolicyName: Output<String>? = null,
    public val signinTenant: Output<String>? = null,
    public val signupPolicyName: Output<String>? = null,
    public val type: Output<Either<String, IdentityProviderType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.IdentityProviderArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.IdentityProviderArgs =
        com.pulumi.azurenative.apimanagement.IdentityProviderArgs.builder()
            .allowedTenants(allowedTenants?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authority(authority?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientLibrary(clientLibrary?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .identityProviderName(identityProviderName?.applyValue({ args0 -> args0 }))
            .passwordResetPolicyName(passwordResetPolicyName?.applyValue({ args0 -> args0 }))
            .profileEditingPolicyName(profileEditingPolicyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .signinPolicyName(signinPolicyName?.applyValue({ args0 -> args0 }))
            .signinTenant(signinTenant?.applyValue({ args0 -> args0 }))
            .signupPolicyName(signupPolicyName?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityProviderArgs].
 */
@PulumiTagMarker
public class IdentityProviderArgsBuilder internal constructor() {
    private var allowedTenants: Output<List<String>>? = null

    private var authority: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientLibrary: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var identityProviderName: Output<String>? = null

    private var passwordResetPolicyName: Output<String>? = null

    private var profileEditingPolicyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var signinPolicyName: Output<String>? = null

    private var signinTenant: Output<String>? = null

    private var signupPolicyName: Output<String>? = null

    private var type: Output<Either<String, IdentityProviderType>>? = null

    /**
     * @param value List of Allowed Tenants when configuring Azure Active Directory login.
     */
    @JvmName("peclbiseddjcvdki")
    public suspend fun allowedTenants(`value`: Output<List<String>>) {
        this.allowedTenants = value
    }

    @JvmName("aoeyunqdkoubqesd")
    public suspend fun allowedTenants(vararg values: Output<String>) {
        this.allowedTenants = Output.all(values.asList())
    }

    /**
     * @param values List of Allowed Tenants when configuring Azure Active Directory login.
     */
    @JvmName("xcgxbpgvocipfmme")
    public suspend fun allowedTenants(values: List<Output<String>>) {
        this.allowedTenants = Output.all(values)
    }

    /**
     * @param value OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
     */
    @JvmName("ykwbytufaafrrlmn")
    public suspend fun authority(`value`: Output<String>) {
        this.authority = value
    }

    /**
     * @param value Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
     */
    @JvmName("ppwgnhfuskcybuui")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The client library to be used in the developer portal. Only applies to AAD and AAD B2C Identity Provider.
     */
    @JvmName("jgusofxgrmojuics")
    public suspend fun clientLibrary(`value`: Output<String>) {
        this.clientLibrary = value
    }

    /**
     * @param value Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
     */
    @JvmName("pdrxyideyqxuvfjf")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Identity Provider Type identifier.
     */
    @JvmName("xdownsbldjwyqmev")
    public suspend fun identityProviderName(`value`: Output<String>) {
        this.identityProviderName = value
    }

    /**
     * @param value Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
     */
    @JvmName("ojfudntjmsextitx")
    public suspend fun passwordResetPolicyName(`value`: Output<String>) {
        this.passwordResetPolicyName = value
    }

    /**
     * @param value Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
     */
    @JvmName("gvjeooeyiddaiouo")
    public suspend fun profileEditingPolicyName(`value`: Output<String>) {
        this.profileEditingPolicyName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ttiyegxtlvjhrhvx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vmpsjatimsyjgvfg")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Signin Policy Name. Only applies to AAD B2C Identity Provider.
     */
    @JvmName("uymraafgoogvpavh")
    public suspend fun signinPolicyName(`value`: Output<String>) {
        this.signinPolicyName = value
    }

    /**
     * @param value The TenantId to use instead of Common when logging into Active Directory
     */
    @JvmName("ptgfutalniiprktl")
    public suspend fun signinTenant(`value`: Output<String>) {
        this.signinTenant = value
    }

    /**
     * @param value Signup Policy Name. Only applies to AAD B2C Identity Provider.
     */
    @JvmName("qeikgvbifghxwdcc")
    public suspend fun signupPolicyName(`value`: Output<String>) {
        this.signupPolicyName = value
    }

    /**
     * @param value Identity Provider Type identifier.
     */
    @JvmName("tuqenrnabxhlpnsw")
    public suspend fun type(`value`: Output<Either<String, IdentityProviderType>>) {
        this.type = value
    }

    /**
     * @param value List of Allowed Tenants when configuring Azure Active Directory login.
     */
    @JvmName("uaugejgemsgxqxjj")
    public suspend fun allowedTenants(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedTenants = mapped
    }

    /**
     * @param values List of Allowed Tenants when configuring Azure Active Directory login.
     */
    @JvmName("nsuyyufihtybnted")
    public suspend fun allowedTenants(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedTenants = mapped
    }

    /**
     * @param value OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
     */
    @JvmName("sqbvrpkajrugdvfw")
    public suspend fun authority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authority = mapped
    }

    /**
     * @param value Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
     */
    @JvmName("eyrprvqvoyqcjcbv")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client library to be used in the developer portal. Only applies to AAD and AAD B2C Identity Provider.
     */
    @JvmName("nqbbregwpyatjelf")
    public suspend fun clientLibrary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientLibrary = mapped
    }

    /**
     * @param value Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
     */
    @JvmName("jluttkvhegrgckup")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Identity Provider Type identifier.
     */
    @JvmName("ckhnrlwxvcfvqsst")
    public suspend fun identityProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProviderName = mapped
    }

    /**
     * @param value Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
     */
    @JvmName("fynjexixjttsgihk")
    public suspend fun passwordResetPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordResetPolicyName = mapped
    }

    /**
     * @param value Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
     */
    @JvmName("sqxaydtrnfxdjevc")
    public suspend fun profileEditingPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileEditingPolicyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ppmthvauiqaapsdp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("cnfpyyumwcovlywj")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Signin Policy Name. Only applies to AAD B2C Identity Provider.
     */
    @JvmName("viamgjandswyadxt")
    public suspend fun signinPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signinPolicyName = mapped
    }

    /**
     * @param value The TenantId to use instead of Common when logging into Active Directory
     */
    @JvmName("svkahyfhyetgkhcp")
    public suspend fun signinTenant(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signinTenant = mapped
    }

    /**
     * @param value Signup Policy Name. Only applies to AAD B2C Identity Provider.
     */
    @JvmName("crxxhjusuyxcnlaf")
    public suspend fun signupPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signupPolicyName = mapped
    }

    /**
     * @param value Identity Provider Type identifier.
     */
    @JvmName("qknjfdqyfrbtmyfg")
    public suspend fun type(`value`: Either<String, IdentityProviderType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Identity Provider Type identifier.
     */
    @JvmName("sbolyechilbcddob")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IdentityProviderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Identity Provider Type identifier.
     */
    @JvmName("cfbsbimktgfnisdi")
    public fun type(`value`: IdentityProviderType) {
        val toBeMapped = Either.ofRight<String, IdentityProviderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityProviderArgs = IdentityProviderArgs(
        allowedTenants = allowedTenants,
        authority = authority,
        clientId = clientId,
        clientLibrary = clientLibrary,
        clientSecret = clientSecret,
        identityProviderName = identityProviderName,
        passwordResetPolicyName = passwordResetPolicyName,
        profileEditingPolicyName = profileEditingPolicyName,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        signinPolicyName = signinPolicyName,
        signinTenant = signinTenant,
        signupPolicyName = signupPolicyName,
        type = type,
    )
}
