@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.LoggerArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.LoggerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Logger details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2018-01-01, 2019-12-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateAILogger
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var logger = new AzureNative.ApiManagement.Logger("logger", new()
 *     {
 *         Credentials =
 *         {
 *             { "instrumentationKey", "11................a1" },
 *         },
 *         Description = "adding a new logger",
 *         LoggerId = "loggerId",
 *         LoggerType = AzureNative.ApiManagement.LoggerType.ApplicationInsights,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewLogger(ctx, "logger", &apimanagement.LoggerArgs{
 * 			Credentials: pulumi.StringMap{
 * 				"instrumentationKey": pulumi.String("11................a1"),
 * 			},
 * 			Description:       pulumi.String("adding a new logger"),
 * 			LoggerId:          pulumi.String("loggerId"),
 * 			LoggerType:        pulumi.String(apimanagement.LoggerTypeApplicationInsights),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Logger;
 * import com.pulumi.azurenative.apimanagement.LoggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var logger = new Logger("logger", LoggerArgs.builder()
 *             .credentials(Map.of("instrumentationKey", "11................a1"))
 *             .description("adding a new logger")
 *             .loggerId("loggerId")
 *             .loggerType("applicationInsights")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateEHLogger
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var logger = new AzureNative.ApiManagement.Logger("logger", new()
 *     {
 *         Credentials =
 *         {
 *             { "connectionString", "Endpoint=sb://hydraeventhub-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=********=" },
 *             { "name", "hydraeventhub" },
 *         },
 *         Description = "adding a new logger",
 *         LoggerId = "eh1",
 *         LoggerType = AzureNative.ApiManagement.LoggerType.AzureEventHub,
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewLogger(ctx, "logger", &apimanagement.LoggerArgs{
 * 			Credentials: pulumi.StringMap{
 * 				"connectionString": pulumi.String("Endpoint=sb://hydraeventhub-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=********="),
 * 				"name":             pulumi.String("hydraeventhub"),
 * 			},
 * 			Description:       pulumi.String("adding a new logger"),
 * 			LoggerId:          pulumi.String("eh1"),
 * 			LoggerType:        pulumi.String(apimanagement.LoggerTypeAzureEventHub),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Logger;
 * import com.pulumi.azurenative.apimanagement.LoggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var logger = new Logger("logger", LoggerArgs.builder()
 *             .credentials(Map.ofEntries(
 *                 Map.entry("connectionString", "Endpoint=sb://hydraeventhub-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=********="),
 *                 Map.entry("name", "hydraeventhub")
 *             ))
 *             .description("adding a new logger")
 *             .loggerId("eh1")
 *             .loggerType("azureEventHub")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Logger eh1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/loggers/{loggerId}
 * ```
 * @property credentials The name and SendRule connection string of the event hub for azureEventHub logger.
 * Instrumentation key for applicationInsights logger.
 * @property description Logger description.
 * @property isBuffered Whether records are buffered in the logger before publishing. Default is assumed to be true.
 * @property loggerId Logger identifier. Must be unique in the API Management service instance.
 * @property loggerType Logger type.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceId Azure Resource Id of a log target (either Azure Event Hub resource or Azure Application Insights resource).
 * @property serviceName The name of the API Management service.
 */
public data class LoggerArgs(
    public val credentials: Output<Map<String, String>>? = null,
    public val description: Output<String>? = null,
    public val isBuffered: Output<Boolean>? = null,
    public val loggerId: Output<String>? = null,
    public val loggerType: Output<Either<String, LoggerType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.LoggerArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.LoggerArgs =
        com.pulumi.azurenative.apimanagement.LoggerArgs.builder()
            .credentials(
                credentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .isBuffered(isBuffered?.applyValue({ args0 -> args0 }))
            .loggerId(loggerId?.applyValue({ args0 -> args0 }))
            .loggerType(
                loggerType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoggerArgs].
 */
@PulumiTagMarker
public class LoggerArgsBuilder internal constructor() {
    private var credentials: Output<Map<String, String>>? = null

    private var description: Output<String>? = null

    private var isBuffered: Output<Boolean>? = null

    private var loggerId: Output<String>? = null

    private var loggerType: Output<Either<String, LoggerType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name and SendRule connection string of the event hub for azureEventHub logger.
     * Instrumentation key for applicationInsights logger.
     */
    @JvmName("fjetkfjeufjktshv")
    public suspend fun credentials(`value`: Output<Map<String, String>>) {
        this.credentials = value
    }

    /**
     * @param value Logger description.
     */
    @JvmName("rogkiqcainjyhnjv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether records are buffered in the logger before publishing. Default is assumed to be true.
     */
    @JvmName("pmcgvvsfytpxatsw")
    public suspend fun isBuffered(`value`: Output<Boolean>) {
        this.isBuffered = value
    }

    /**
     * @param value Logger identifier. Must be unique in the API Management service instance.
     */
    @JvmName("ppnyykprwcjdamfc")
    public suspend fun loggerId(`value`: Output<String>) {
        this.loggerId = value
    }

    /**
     * @param value Logger type.
     */
    @JvmName("ewmrjbhvxbcoprvw")
    public suspend fun loggerType(`value`: Output<Either<String, LoggerType>>) {
        this.loggerType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yujevcxpfrhsoplt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Resource Id of a log target (either Azure Event Hub resource or Azure Application Insights resource).
     */
    @JvmName("tjtgbhxwnmtifsns")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("xtawsbjpooviepbs")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name and SendRule connection string of the event hub for azureEventHub logger.
     * Instrumentation key for applicationInsights logger.
     */
    @JvmName("fwxlfdabdoouwoej")
    public suspend fun credentials(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param values The name and SendRule connection string of the event hub for azureEventHub logger.
     * Instrumentation key for applicationInsights logger.
     */
    @JvmName("lrpqctgwjhooyinr")
    public fun credentials(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value Logger description.
     */
    @JvmName("qepybbtvhxbfwluh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether records are buffered in the logger before publishing. Default is assumed to be true.
     */
    @JvmName("nvpafbfnqaxppjso")
    public suspend fun isBuffered(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isBuffered = mapped
    }

    /**
     * @param value Logger identifier. Must be unique in the API Management service instance.
     */
    @JvmName("kwsjcdwqkwfsypiq")
    public suspend fun loggerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggerId = mapped
    }

    /**
     * @param value Logger type.
     */
    @JvmName("envuiclulavalndk")
    public suspend fun loggerType(`value`: Either<String, LoggerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggerType = mapped
    }

    /**
     * @param value Logger type.
     */
    @JvmName("fxiqqftpfklcxmot")
    public fun loggerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoggerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loggerType = mapped
    }

    /**
     * @param value Logger type.
     */
    @JvmName("nlfqjvwethnbqdxt")
    public fun loggerType(`value`: LoggerType) {
        val toBeMapped = Either.ofRight<String, LoggerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loggerType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iemamgnllanqwqqa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Resource Id of a log target (either Azure Event Hub resource or Azure Application Insights resource).
     */
    @JvmName("jxyxpjampmpvwckh")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("lepcebtdccpsdfkx")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): LoggerArgs = LoggerArgs(
        credentials = credentials,
        description = description,
        isBuffered = isBuffered,
        loggerId = loggerId,
        loggerType = loggerType,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        serviceName = serviceName,
    )
}
