@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.PolicyArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.PolicyContentFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2018-06-01-preview, 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreatePolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.ApiManagement.Policy("policy", new()
 *     {
 *         Format = AzureNative.ApiManagement.PolicyContentFormat.Xml,
 *         PolicyId = "policy",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = @"<policies>
 *   <inbound />
 *   <backend>
 *     <forward-request />
 *   </backend>
 *   <outbound />
 * </policies>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewPolicy(ctx, "policy", &apimanagement.PolicyArgs{
 * 			Format:            pulumi.String(apimanagement.PolicyContentFormatXml),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.String(`<policies>
 *   <inbound />
 *   <backend>
 *     <forward-request />
 *   </backend>
 *   <outbound />
 * </policies>`),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Policy;
 * import com.pulumi.azurenative.apimanagement.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .format("xml")
 *             .policyId("policy")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("""
 * <policies>
 *   <inbound />
 *   <backend>
 *     <forward-request />
 *   </backend>
 *   <outbound />
 * </policies>            """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Policy policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/policies/{policyId}
 * ```
 * @property format Format of the policyContent.
 * @property policyId The identifier of the Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property value Contents of the Policy as defined by the format.
 */
public data class PolicyArgs(
    public val format: Output<Either<String, PolicyContentFormat>>? = null,
    public val policyId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.PolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.PolicyArgs =
        com.pulumi.azurenative.apimanagement.PolicyArgs.builder()
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var format: Output<Either<String, PolicyContentFormat>>? = null

    private var policyId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("wiwxxxbxrfycrtol")
    public suspend fun format(`value`: Output<Either<String, PolicyContentFormat>>) {
        this.format = value
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("tndfatahbhpnxnuy")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bajejoefpbgplnbl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("wrsttillidjoyhjj")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Contents of the Policy as defined by the format.
     */
    @JvmName("mghmdotbyyjpvxfs")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("ogweptmqohmaoiqa")
    public suspend fun format(`value`: Either<String, PolicyContentFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("ovuqljsapbyguych")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("eypnbfcyiwttkxag")
    public fun format(`value`: PolicyContentFormat) {
        val toBeMapped = Either.ofRight<String, PolicyContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("cpxjgmwojqjcxeyp")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yrpjudcfwpsdvthl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("qpaxqedbbryqdwrk")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Contents of the Policy as defined by the format.
     */
    @JvmName("bljaphcpwibdjtuw")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        format = format,
        policyId = policyId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        `value` = `value`,
    )
}
