@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PolicyRestriction].
 */
@PulumiTagMarker
public class PolicyRestrictionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyRestrictionArgs = PolicyRestrictionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyRestrictionArgsBuilder.() -> Unit) {
        val builder = PolicyRestrictionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyRestriction {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.PolicyRestriction(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyRestriction(builtJavaResource)
    }
}

/**
 * Policy restriction contract details.
 * Azure REST API version: 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreatePolicyRestriction
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyRestriction = new AzureNative.ApiManagement.PolicyRestriction("policyRestriction", new()
 *     {
 *         PolicyRestrictionId = "policyRestriction1",
 *         RequireBase = AzureNative.ApiManagement.PolicyRestrictionRequireBase.@True,
 *         ResourceGroupName = "rg1",
 *         Scope = "Sample Path to the policy document.",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewPolicyRestriction(ctx, "policyRestriction", &apimanagement.PolicyRestrictionArgs{
 * 			PolicyRestrictionId: pulumi.String("policyRestriction1"),
 * 			RequireBase:         pulumi.String(apimanagement.PolicyRestrictionRequireBaseTrue),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			Scope:               pulumi.String("Sample Path to the policy document."),
 * 			ServiceName:         pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.PolicyRestriction;
 * import com.pulumi.azurenative.apimanagement.PolicyRestrictionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyRestriction = new PolicyRestriction("policyRestriction", PolicyRestrictionArgs.builder()
 *             .policyRestrictionId("policyRestriction1")
 *             .requireBase("true")
 *             .resourceGroupName("rg1")
 *             .scope("Sample Path to the policy document.")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:PolicyRestriction policyRestrictions1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/policyRestrictions/{policyRestrictionId}
 * ```
 */
public class PolicyRestriction internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.PolicyRestriction,
) : KotlinCustomResource(javaResource, PolicyRestrictionMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Indicates if base policy should be enforced for the policy document.
     */
    public val requireBase: Output<String>?
        get() = javaResource.requireBase().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Path to the policy document.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyRestrictionMapper : ResourceMapper<PolicyRestriction> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.PolicyRestriction::class == javaResource::class

    override fun map(javaResource: Resource): PolicyRestriction = PolicyRestriction(
        javaResource as
            com.pulumi.azurenative.apimanagement.PolicyRestriction,
    )
}

/**
 * @see [PolicyRestriction].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyRestriction].
 */
public suspend fun policyRestriction(
    name: String,
    block: suspend PolicyRestrictionResourceBuilder.() -> Unit,
): PolicyRestriction {
    val builder = PolicyRestrictionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyRestriction].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyRestriction(name: String): PolicyRestriction {
    val builder = PolicyRestrictionResourceBuilder()
    builder.name(name)
    return builder.build()
}
