@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.apimanagement.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin

/**
 * Builder for [PrivateEndpointConnectionByName].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionByNameResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionByNameArgs = PrivateEndpointConnectionByNameArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionByNameArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionByNameArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateEndpointConnectionByName {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByName(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnectionByName(builtJavaResource)
    }
}

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementApproveOrRejectPrivateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionByName = new AzureNative.ApiManagement.PrivateEndpointConnectionByName("privateEndpointConnectionByName", new()
 *     {
 *         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/privateEndpointConnections/connectionName",
 *         PrivateEndpointConnectionName = "privateEndpointConnectionName",
 *         Properties = new AzureNative.ApiManagement.Inputs.PrivateEndpointConnectionRequestPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.ApiManagement.Inputs.PrivateLinkServiceConnectionStateArgs
 *             {
 *                 Description = "The Private Endpoint Connection is approved.",
 *                 Status = AzureNative.ApiManagement.PrivateEndpointServiceConnectionStatus.Approved,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewPrivateEndpointConnectionByName(ctx, "privateEndpointConnectionByName", &apimanagement.PrivateEndpointConnectionByNameArgs{
 * 			Id:                            pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/privateEndpointConnections/connectionName"),
 * 			PrivateEndpointConnectionName: pulumi.String("privateEndpointConnectionName"),
 * 			Properties: &apimanagement.PrivateEndpointConnectionRequestPropertiesArgs{
 * 				PrivateLinkServiceConnectionState: &apimanagement.PrivateLinkServiceConnectionStateArgs{
 * 					Description: pulumi.String("The Private Endpoint Connection is approved."),
 * 					Status:      pulumi.String(apimanagement.PrivateEndpointServiceConnectionStatusApproved),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByName;
 * import com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByNameArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.PrivateEndpointConnectionRequestPropertiesArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionByName = new PrivateEndpointConnectionByName("privateEndpointConnectionByName", PrivateEndpointConnectionByNameArgs.builder()
 *             .id("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/privateEndpointConnections/connectionName")
 *             .privateEndpointConnectionName("privateEndpointConnectionName")
 *             .properties(PrivateEndpointConnectionRequestPropertiesArgs.builder()
 *                 .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                     .description("The Private Endpoint Connection is approved.")
 *                     .status("Approved")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:PrivateEndpointConnectionByName privateEndpointConnectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class PrivateEndpointConnectionByName internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByName,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionByNameMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource of private end point.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A collection of information about the state of the connection between service consumer and provider.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.let({ args0 -> privateLinkServiceConnectionStateResponseToKotlin(args0) })
        })

    /**
     * The provisioning state of the private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionByNameMapper :
    ResourceMapper<PrivateEndpointConnectionByName> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByName::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnectionByName =
        PrivateEndpointConnectionByName(
            javaResource as
                com.pulumi.azurenative.apimanagement.PrivateEndpointConnectionByName,
        )
}

/**
 * @see [PrivateEndpointConnectionByName].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnectionByName].
 */
public suspend fun privateEndpointConnectionByName(
    name: String,
    block: suspend PrivateEndpointConnectionByNameResourceBuilder.() -> Unit,
): PrivateEndpointConnectionByName {
    val builder = PrivateEndpointConnectionByNameResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnectionByName].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnectionByName(name: String): PrivateEndpointConnectionByName {
    val builder = PrivateEndpointConnectionByNameResourceBuilder()
    builder.name(name)
    return builder.build()
}
