@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ProductGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateProductGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var productGroup = new AzureNative.ApiManagement.ProductGroup("productGroup", new()
 *     {
 *         GroupId = "templateGroup",
 *         ProductId = "testproduct",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewProductGroup(ctx, "productGroup", &apimanagement.ProductGroupArgs{
 * 			GroupId:           pulumi.String("templateGroup"),
 * 			ProductId:         pulumi.String("testproduct"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ProductGroup;
 * import com.pulumi.azurenative.apimanagement.ProductGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var productGroup = new ProductGroup("productGroup", ProductGroupArgs.builder()
 *             .groupId("templateGroup")
 *             .productId("testproduct")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ProductGroup templateGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/groups/{groupId}
 * ```
 * @property groupId Group identifier. Must be unique in the current API Management service instance.
 * @property productId Product identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class ProductGroupArgs(
    public val groupId: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ProductGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ProductGroupArgs =
        com.pulumi.azurenative.apimanagement.ProductGroupArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProductGroupArgs].
 */
@PulumiTagMarker
public class ProductGroupArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var productId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("wlglssnaekhxenwe")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("bjuayrvgyclnrrfq")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tgjyidwmqyjlpigc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("pnaftdeiauygchgr")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("yhmthjmthmtekmul")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("hbayhvshmtxgfyeu")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vqxmnivkvveixmlt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vkbsfsepgetnedbo")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ProductGroupArgs = ProductGroupArgs(
        groupId = groupId,
        productId = productId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
