@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Schema].
 */
@PulumiTagMarker
public class SchemaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SchemaArgs = SchemaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SchemaArgsBuilder.() -> Unit) {
        val builder = SchemaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Schema {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.Schema(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schema(builtJavaResource)
    }
}

/**
 * Schema Contract details.
 * Azure REST API version: 2021-04-01-preview. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateSchema1
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schema = new AzureNative.ApiManagement.Schema("schema", new()
 *     {
 *         Description = "sample schema description",
 *         ResourceGroupName = "rg1",
 *         SchemaId = "schema1",
 *         SchemaType = AzureNative.ApiManagement.SchemaType.Xml,
 *         ServiceName = "apimService1",
 *         Value = @"<xsd:schema xmlns:xsd=""http://www.w3.org/2001/XMLSchema""
 *            xmlns:tns=""http://tempuri.org/PurchaseOrderSchema.xsd""
 *            targetNamespace=""http://tempuri.org/PurchaseOrderSchema.xsd""
 *            elementFormDefault=""qualified"">
 *  <xsd:element name=""PurchaseOrder"" type=""tns:PurchaseOrderType""/>
 *  <xsd:complexType name=""PurchaseOrderType"">
 *   <xsd:sequence>
 *    <xsd:element name=""ShipTo"" type=""tns:USAddress"" maxOccurs=""2""/>
 *    <xsd:element name=""BillTo"" type=""tns:USAddress""/>
 *   </xsd:sequence>
 *   <xsd:attribute name=""OrderDate"" type=""xsd:date""/>
 *  </xsd:complexType>
 *  <xsd:complexType name=""USAddress"">
 *   <xsd:sequence>
 *    <xsd:element name=""name""   type=""xsd:string""/>
 *    <xsd:element name=""street"" type=""xsd:string""/>
 *    <xsd:element name=""city""   type=""xsd:string""/>
 *    <xsd:element name=""state""  type=""xsd:string""/>
 *    <xsd:element name=""zip""    type=""xsd:integer""/>
 *   </xsd:sequence>
 *   <xsd:attribute name=""country"" type=""xsd:NMTOKEN"" fixed=""US""/>
 *  </xsd:complexType>
 * </xsd:schema>",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewSchema(ctx, "schema", &apimanagement.SchemaArgs{
 * 			Description:       pulumi.String("sample schema description"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SchemaId:          pulumi.String("schema1"),
 * 			SchemaType:        pulumi.String(apimanagement.SchemaTypeXml),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.String(`<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"
 *            xmlns:tns="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            targetNamespace="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            elementFormDefault="qualified">
 *  <xsd:element name="PurchaseOrder" type="tns:PurchaseOrderType"/>
 *  <xsd:complexType name="PurchaseOrderType">
 *   <xsd:sequence>
 *    <xsd:element name="ShipTo" type="tns:USAddress" maxOccurs="2"/>
 *    <xsd:element name="BillTo" type="tns:USAddress"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="OrderDate" type="xsd:date"/>
 *  </xsd:complexType>
 *  <xsd:complexType name="USAddress">
 *   <xsd:sequence>
 *    <xsd:element name="name"   type="xsd:string"/>
 *    <xsd:element name="street" type="xsd:string"/>
 *    <xsd:element name="city"   type="xsd:string"/>
 *    <xsd:element name="state"  type="xsd:string"/>
 *    <xsd:element name="zip"    type="xsd:integer"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="country" type="xsd:NMTOKEN" fixed="US"/>
 *  </xsd:complexType>
 * </xsd:schema>`),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Schema;
 * import com.pulumi.azurenative.apimanagement.SchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schema = new Schema("schema", SchemaArgs.builder()
 *             .description("sample schema description")
 *             .resourceGroupName("rg1")
 *             .schemaId("schema1")
 *             .schemaType("xml")
 *             .serviceName("apimService1")
 *             .value("""
 * <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"
 *            xmlns:tns="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            targetNamespace="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            elementFormDefault="qualified">
 *  <xsd:element name="PurchaseOrder" type="tns:PurchaseOrderType"/>
 *  <xsd:complexType name="PurchaseOrderType">
 *   <xsd:sequence>
 *    <xsd:element name="ShipTo" type="tns:USAddress" maxOccurs="2"/>
 *    <xsd:element name="BillTo" type="tns:USAddress"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="OrderDate" type="xsd:date"/>
 *  </xsd:complexType>
 *  <xsd:complexType name="USAddress">
 *   <xsd:sequence>
 *    <xsd:element name="name"   type="xsd:string"/>
 *    <xsd:element name="street" type="xsd:string"/>
 *    <xsd:element name="city"   type="xsd:string"/>
 *    <xsd:element name="state"  type="xsd:string"/>
 *    <xsd:element name="zip"    type="xsd:integer"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="country" type="xsd:NMTOKEN" fixed="US"/>
 *  </xsd:complexType>
 * </xsd:schema>            """)
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateSchema2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schema = new AzureNative.ApiManagement.Schema("schema", new()
 *     {
 *         Description = "sample schema description",
 *         ResourceGroupName = "rg1",
 *         SchemaId = "schema1",
 *         SchemaType = AzureNative.ApiManagement.SchemaType.Json,
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewSchema(ctx, "schema", &apimanagement.SchemaArgs{
 * 			Description:       pulumi.String("sample schema description"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SchemaId:          pulumi.String("schema1"),
 * 			SchemaType:        pulumi.String(apimanagement.SchemaTypeJson),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Schema;
 * import com.pulumi.azurenative.apimanagement.SchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schema = new Schema("schema", SchemaArgs.builder()
 *             .description("sample schema description")
 *             .resourceGroupName("rg1")
 *             .schemaId("schema1")
 *             .schemaType("json")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Schema schema1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/schemas/{schemaId}
 * ```
 */
public class Schema internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.Schema,
) : KotlinCustomResource(javaResource, SchemaMapper) {
    /**
     * Free-form schema entity description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Schema Type. Immutable.
     */
    public val schemaType: Output<String>
        get() = javaResource.schemaType().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Json-encoded string for non json-based schema.
     */
    public val `value`: Output<String>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SchemaMapper : ResourceMapper<Schema> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.Schema::class == javaResource::class

    override fun map(javaResource: Resource): Schema = Schema(
        javaResource as
            com.pulumi.azurenative.apimanagement.Schema,
    )
}

/**
 * @see [Schema].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schema].
 */
public suspend fun schema(name: String, block: suspend SchemaResourceBuilder.() -> Unit): Schema {
    val builder = SchemaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schema].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schema(name: String): Schema {
    val builder = SchemaResourceBuilder()
    builder.name(name)
    return builder.build()
}
