@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TagByApi].
 */
@PulumiTagMarker
public class TagByApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagByApiArgs = TagByApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagByApiArgsBuilder.() -> Unit) {
        val builder = TagByApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TagByApi {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.TagByApi(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TagByApi(builtJavaResource)
    }
}

/**
 * Tag Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiTag
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagByApi = new AzureNative.ApiManagement.TagByApi("tagByApi", new()
 *     {
 *         ApiId = "5931a75ae4bbd512a88c680b",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TagId = "tagId1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewTagByApi(ctx, "tagByApi", &apimanagement.TagByApiArgs{
 * 			ApiId:             pulumi.String("5931a75ae4bbd512a88c680b"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			TagId:             pulumi.String("tagId1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.TagByApi;
 * import com.pulumi.azurenative.apimanagement.TagByApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagByApi = new TagByApi("tagByApi", TagByApiArgs.builder()
 *             .apiId("5931a75ae4bbd512a88c680b")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tagId("tagId1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:TagByApi tagId1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tags/{tagId}
 * ```
 */
public class TagByApi internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.TagByApi,
) : KotlinCustomResource(javaResource, TagByApiMapper) {
    /**
     * Tag name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TagByApiMapper : ResourceMapper<TagByApi> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.TagByApi::class == javaResource::class

    override fun map(javaResource: Resource): TagByApi = TagByApi(
        javaResource as
            com.pulumi.azurenative.apimanagement.TagByApi,
    )
}

/**
 * @see [TagByApi].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TagByApi].
 */
public suspend fun tagByApi(name: String, block: suspend TagByApiResourceBuilder.() -> Unit): TagByApi {
    val builder = TagByApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TagByApi].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tagByApi(name: String): TagByApi {
    val builder = TagByApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
