@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspaceApiArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.ApiType
import com.pulumi.azurenative.apimanagement.kotlin.enums.ContentFormat
import com.pulumi.azurenative.apimanagement.kotlin.enums.Protocol
import com.pulumi.azurenative.apimanagement.kotlin.enums.SoapApiType
import com.pulumi.azurenative.apimanagement.kotlin.enums.TranslateRequiredQueryParametersConduct
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiContactInformationArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiContactInformationArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiLicenseInformationArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiLicenseInformationArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiVersionSetContractDetailsArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ApiVersionSetContractDetailsArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.AuthenticationSettingsContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.AuthenticationSettingsContractArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.SubscriptionKeyParameterNamesContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.SubscriptionKeyParameterNamesContractArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * API details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceApi = new AzureNative.ApiManagement.WorkspaceApi("workspaceApi", new()
 *     {
 *         ApiId = "tempgroup",
 *         AuthenticationSettings = new AzureNative.ApiManagement.Inputs.AuthenticationSettingsContractArgs
 *         {
 *             OAuth2 = new AzureNative.ApiManagement.Inputs.OAuth2AuthenticationSettingsContractArgs
 *             {
 *                 AuthorizationServerId = "authorizationServerId2283",
 *                 Scope = "oauth2scope2580",
 *             },
 *         },
 *         Description = "apidescription5200",
 *         DisplayName = "apiname1463",
 *         Path = "newapiPath",
 *         Protocols = new[]
 *         {
 *             AzureNative.ApiManagement.Protocol.Https,
 *             AzureNative.ApiManagement.Protocol.Http,
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         ServiceUrl = "http://newechoapi.cloudapp.net/api",
 *         SubscriptionKeyParameterNames = new AzureNative.ApiManagement.Inputs.SubscriptionKeyParameterNamesContractArgs
 *         {
 *             Header = "header4520",
 *             Query = "query3037",
 *         },
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceApi(ctx, "workspaceApi", &apimanagement.WorkspaceApiArgs{
 * 			ApiId: pulumi.String("tempgroup"),
 * 			AuthenticationSettings: &apimanagement.AuthenticationSettingsContractArgs{
 * 				OAuth2: &apimanagement.OAuth2AuthenticationSettingsContractArgs{
 * 					AuthorizationServerId: pulumi.String("authorizationServerId2283"),
 * 					Scope:                 pulumi.String("oauth2scope2580"),
 * 				},
 * 			},
 * 			Description: pulumi.String("apidescription5200"),
 * 			DisplayName: pulumi.String("apiname1463"),
 * 			Path:        pulumi.String("newapiPath"),
 * 			Protocols: pulumi.StringArray{
 * 				pulumi.String(apimanagement.ProtocolHttps),
 * 				pulumi.String(apimanagement.ProtocolHttp),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			ServiceUrl:        pulumi.String("http://newechoapi.cloudapp.net/api"),
 * 			SubscriptionKeyParameterNames: &apimanagement.SubscriptionKeyParameterNamesContractArgs{
 * 				Header: pulumi.String("header4520"),
 * 				Query:  pulumi.String("query3037"),
 * 			},
 * 			WorkspaceId: pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceApi;
 * import com.pulumi.azurenative.apimanagement.WorkspaceApiArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.AuthenticationSettingsContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.OAuth2AuthenticationSettingsContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.SubscriptionKeyParameterNamesContractArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceApi = new WorkspaceApi("workspaceApi", WorkspaceApiArgs.builder()
 *             .apiId("tempgroup")
 *             .authenticationSettings(AuthenticationSettingsContractArgs.builder()
 *                 .oAuth2(OAuth2AuthenticationSettingsContractArgs.builder()
 *                     .authorizationServerId("authorizationServerId2283")
 *                     .scope("oauth2scope2580")
 *                     .build())
 *                 .build())
 *             .description("apidescription5200")
 *             .displayName("apiname1463")
 *             .path("newapiPath")
 *             .protocols(
 *                 "https",
 *                 "http")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .serviceUrl("http://newechoapi.cloudapp.net/api")
 *             .subscriptionKeyParameterNames(SubscriptionKeyParameterNamesContractArgs.builder()
 *                 .header("header4520")
 *                 .query("query3037")
 *                 .build())
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceApi apiid9419 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis/{apiId}
 * ```
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property apiRevision Describes the revision of the API. If no value is provided, default revision 1 is created
 * @property apiRevisionDescription Description of the API Revision.
 * @property apiType Type of API.
 * @property apiVersion Indicates the version identifier of the API if the API is versioned
 * @property apiVersionDescription Description of the API Version.
 * @property apiVersionSet Version set details
 * @property apiVersionSetId A resource identifier for the related ApiVersionSet.
 * @property authenticationSettings Collection of authentication settings included into this API.
 * @property contact Contact information for the API.
 * @property description Description of the API. May include HTML formatting tags.
 * @property displayName API name. Must be 1 to 300 characters long.
 * @property format Format of the Content in which the API is getting imported.
 * @property isCurrent Indicates if API revision is current api revision.
 * @property license License information for the API.
 * @property path Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
 * @property protocols Describes on which protocols the operations in this API can be invoked.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property serviceUrl Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
 * @property soapApiType Type of API to create.
 *  * `http` creates a REST API
 *  * `soap` creates a SOAP pass-through API
 *  * `websocket` creates websocket API
 *  * `graphql` creates GraphQL API.
 * @property sourceApiId API identifier of the source API.
 * @property subscriptionKeyParameterNames Protocols over which API is made available.
 * @property subscriptionRequired Specifies whether an API or Product subscription is required for accessing the API.
 * @property termsOfServiceUrl  A URL to the Terms of Service for the API. MUST be in the format of a URL.
 * @property translateRequiredQueryParametersConduct Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
 * @property value Content value when Importing an API.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 * @property wsdlSelector Criteria to limit import of WSDL to a subset of the document.
 */
public data class WorkspaceApiArgs(
    public val apiId: Output<String>? = null,
    public val apiRevision: Output<String>? = null,
    public val apiRevisionDescription: Output<String>? = null,
    public val apiType: Output<Either<String, ApiType>>? = null,
    public val apiVersion: Output<String>? = null,
    public val apiVersionDescription: Output<String>? = null,
    public val apiVersionSet: Output<ApiVersionSetContractDetailsArgs>? = null,
    public val apiVersionSetId: Output<String>? = null,
    public val authenticationSettings: Output<AuthenticationSettingsContractArgs>? = null,
    public val contact: Output<ApiContactInformationArgs>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val format: Output<Either<String, ContentFormat>>? = null,
    public val isCurrent: Output<Boolean>? = null,
    public val license: Output<ApiLicenseInformationArgs>? = null,
    public val path: Output<String>? = null,
    public val protocols: Output<List<Either<String, Protocol>>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val serviceUrl: Output<String>? = null,
    public val soapApiType: Output<Either<String, SoapApiType>>? = null,
    public val sourceApiId: Output<String>? = null,
    public val subscriptionKeyParameterNames: Output<SubscriptionKeyParameterNamesContractArgs>? =
        null,
    public val subscriptionRequired: Output<Boolean>? = null,
    public val termsOfServiceUrl: Output<String>? = null,
    public val translateRequiredQueryParametersConduct: Output<Either<String, TranslateRequiredQueryParametersConduct>>? = null,
    public val `value`: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
    public val wsdlSelector: Output<ApiCreateOrUpdatePropertiesWsdlSelectorArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspaceApiArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspaceApiArgs =
        com.pulumi.azurenative.apimanagement.WorkspaceApiArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .apiRevision(apiRevision?.applyValue({ args0 -> args0 }))
            .apiRevisionDescription(apiRevisionDescription?.applyValue({ args0 -> args0 }))
            .apiType(
                apiType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .apiVersion(apiVersion?.applyValue({ args0 -> args0 }))
            .apiVersionDescription(apiVersionDescription?.applyValue({ args0 -> args0 }))
            .apiVersionSet(apiVersionSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .apiVersionSetId(apiVersionSetId?.applyValue({ args0 -> args0 }))
            .authenticationSettings(
                authenticationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .contact(contact?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .isCurrent(isCurrent?.applyValue({ args0 -> args0 }))
            .license(license?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0 }))
            .protocols(
                protocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .serviceUrl(serviceUrl?.applyValue({ args0 -> args0 }))
            .soapApiType(
                soapApiType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceApiId(sourceApiId?.applyValue({ args0 -> args0 }))
            .subscriptionKeyParameterNames(
                subscriptionKeyParameterNames?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .subscriptionRequired(subscriptionRequired?.applyValue({ args0 -> args0 }))
            .termsOfServiceUrl(termsOfServiceUrl?.applyValue({ args0 -> args0 }))
            .translateRequiredQueryParametersConduct(
                translateRequiredQueryParametersConduct?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 }))
            .wsdlSelector(wsdlSelector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WorkspaceApiArgs].
 */
@PulumiTagMarker
public class WorkspaceApiArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var apiRevision: Output<String>? = null

    private var apiRevisionDescription: Output<String>? = null

    private var apiType: Output<Either<String, ApiType>>? = null

    private var apiVersion: Output<String>? = null

    private var apiVersionDescription: Output<String>? = null

    private var apiVersionSet: Output<ApiVersionSetContractDetailsArgs>? = null

    private var apiVersionSetId: Output<String>? = null

    private var authenticationSettings: Output<AuthenticationSettingsContractArgs>? = null

    private var contact: Output<ApiContactInformationArgs>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var format: Output<Either<String, ContentFormat>>? = null

    private var isCurrent: Output<Boolean>? = null

    private var license: Output<ApiLicenseInformationArgs>? = null

    private var path: Output<String>? = null

    private var protocols: Output<List<Either<String, Protocol>>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var serviceUrl: Output<String>? = null

    private var soapApiType: Output<Either<String, SoapApiType>>? = null

    private var sourceApiId: Output<String>? = null

    private var subscriptionKeyParameterNames: Output<SubscriptionKeyParameterNamesContractArgs>? =
        null

    private var subscriptionRequired: Output<Boolean>? = null

    private var termsOfServiceUrl: Output<String>? = null

    private var translateRequiredQueryParametersConduct:
        Output<Either<String, TranslateRequiredQueryParametersConduct>>? = null

    private var `value`: Output<String>? = null

    private var workspaceId: Output<String>? = null

    private var wsdlSelector: Output<ApiCreateOrUpdatePropertiesWsdlSelectorArgs>? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("akrolxvywpxbwegr")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Describes the revision of the API. If no value is provided, default revision 1 is created
     */
    @JvmName("sheexdivfrbciylt")
    public suspend fun apiRevision(`value`: Output<String>) {
        this.apiRevision = value
    }

    /**
     * @param value Description of the API Revision.
     */
    @JvmName("xaeorkdfndrbjuwk")
    public suspend fun apiRevisionDescription(`value`: Output<String>) {
        this.apiRevisionDescription = value
    }

    /**
     * @param value Type of API.
     */
    @JvmName("rliycrkmpabcdcpo")
    public suspend fun apiType(`value`: Output<Either<String, ApiType>>) {
        this.apiType = value
    }

    /**
     * @param value Indicates the version identifier of the API if the API is versioned
     */
    @JvmName("uyflnkfhgvxfjntd")
    public suspend fun apiVersion(`value`: Output<String>) {
        this.apiVersion = value
    }

    /**
     * @param value Description of the API Version.
     */
    @JvmName("bkwutxjknjqaduid")
    public suspend fun apiVersionDescription(`value`: Output<String>) {
        this.apiVersionDescription = value
    }

    /**
     * @param value Version set details
     */
    @JvmName("vcqrjegacujgrmtc")
    public suspend fun apiVersionSet(`value`: Output<ApiVersionSetContractDetailsArgs>) {
        this.apiVersionSet = value
    }

    /**
     * @param value A resource identifier for the related ApiVersionSet.
     */
    @JvmName("muaqsctvosvvljgr")
    public suspend fun apiVersionSetId(`value`: Output<String>) {
        this.apiVersionSetId = value
    }

    /**
     * @param value Collection of authentication settings included into this API.
     */
    @JvmName("wrmwbkpnqqfjpiss")
    public suspend fun authenticationSettings(`value`: Output<AuthenticationSettingsContractArgs>) {
        this.authenticationSettings = value
    }

    /**
     * @param value Contact information for the API.
     */
    @JvmName("loytrspnomhmwdqv")
    public suspend fun contact(`value`: Output<ApiContactInformationArgs>) {
        this.contact = value
    }

    /**
     * @param value Description of the API. May include HTML formatting tags.
     */
    @JvmName("lmvkpjvlustagneu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value API name. Must be 1 to 300 characters long.
     */
    @JvmName("esyptssdanoccdaw")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Format of the Content in which the API is getting imported.
     */
    @JvmName("ogbjhudmmhivwubn")
    public suspend fun format(`value`: Output<Either<String, ContentFormat>>) {
        this.format = value
    }

    /**
     * @param value Indicates if API revision is current api revision.
     */
    @JvmName("vpshttctkyuwqlku")
    public suspend fun isCurrent(`value`: Output<Boolean>) {
        this.isCurrent = value
    }

    /**
     * @param value License information for the API.
     */
    @JvmName("euahobueygkhksat")
    public suspend fun license(`value`: Output<ApiLicenseInformationArgs>) {
        this.license = value
    }

    /**
     * @param value Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
     */
    @JvmName("vnrfdnixaftgiabp")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Describes on which protocols the operations in this API can be invoked.
     */
    @JvmName("gkoewthovbsgmvot")
    public suspend fun protocols(`value`: Output<List<Either<String, Protocol>>>) {
        this.protocols = value
    }

    @JvmName("unchhttqctqvwhtb")
    public suspend fun protocols(vararg values: Output<Either<String, Protocol>>) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values Describes on which protocols the operations in this API can be invoked.
     */
    @JvmName("beoomonfyysncokr")
    public suspend fun protocols(values: List<Output<Either<String, Protocol>>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pibwhhklwhajofvw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ighykinqlrhvvvfd")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
     */
    @JvmName("lssqaaaodonrengy")
    public suspend fun serviceUrl(`value`: Output<String>) {
        this.serviceUrl = value
    }

    /**
     * @param value Type of API to create.
     *  * `http` creates a REST API
     *  * `soap` creates a SOAP pass-through API
     *  * `websocket` creates websocket API
     *  * `graphql` creates GraphQL API.
     */
    @JvmName("mrhlxfgrngflilgl")
    public suspend fun soapApiType(`value`: Output<Either<String, SoapApiType>>) {
        this.soapApiType = value
    }

    /**
     * @param value API identifier of the source API.
     */
    @JvmName("lqmcddymmjsrlwlf")
    public suspend fun sourceApiId(`value`: Output<String>) {
        this.sourceApiId = value
    }

    /**
     * @param value Protocols over which API is made available.
     */
    @JvmName("inldmgeejwelwffe")
    public suspend fun subscriptionKeyParameterNames(`value`: Output<SubscriptionKeyParameterNamesContractArgs>) {
        this.subscriptionKeyParameterNames = value
    }

    /**
     * @param value Specifies whether an API or Product subscription is required for accessing the API.
     */
    @JvmName("ltajvhmrkvnyidbw")
    public suspend fun subscriptionRequired(`value`: Output<Boolean>) {
        this.subscriptionRequired = value
    }

    /**
     * @param value  A URL to the Terms of Service for the API. MUST be in the format of a URL.
     */
    @JvmName("aljlfxgifjbmrhit")
    public suspend fun termsOfServiceUrl(`value`: Output<String>) {
        this.termsOfServiceUrl = value
    }

    /**
     * @param value Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
     */
    @JvmName("unvmxevcpcxvchay")
    public suspend fun translateRequiredQueryParametersConduct(`value`: Output<Either<String, TranslateRequiredQueryParametersConduct>>) {
        this.translateRequiredQueryParametersConduct = value
    }

    /**
     * @param value Content value when Importing an API.
     */
    @JvmName("lvtavyenskgixpfs")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("jjaudrhaidyrxuef")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Criteria to limit import of WSDL to a subset of the document.
     */
    @JvmName("eyxeancnqpgjpoiv")
    public suspend fun wsdlSelector(`value`: Output<ApiCreateOrUpdatePropertiesWsdlSelectorArgs>) {
        this.wsdlSelector = value
    }

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("nurvbktnxaxyshrl")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Describes the revision of the API. If no value is provided, default revision 1 is created
     */
    @JvmName("bmmdqnotyeyqfgij")
    public suspend fun apiRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiRevision = mapped
    }

    /**
     * @param value Description of the API Revision.
     */
    @JvmName("vwfjjqmagppauttk")
    public suspend fun apiRevisionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiRevisionDescription = mapped
    }

    /**
     * @param value Type of API.
     */
    @JvmName("hxecpuscucxaxbod")
    public suspend fun apiType(`value`: Either<String, ApiType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiType = mapped
    }

    /**
     * @param value Type of API.
     */
    @JvmName("srscitjlobhxqgtx")
    public fun apiType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApiType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiType = mapped
    }

    /**
     * @param value Type of API.
     */
    @JvmName("iqityrxxhiyrnejt")
    public fun apiType(`value`: ApiType) {
        val toBeMapped = Either.ofRight<String, ApiType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiType = mapped
    }

    /**
     * @param value Indicates the version identifier of the API if the API is versioned
     */
    @JvmName("abnugljvbuwegyrc")
    public suspend fun apiVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersion = mapped
    }

    /**
     * @param value Description of the API Version.
     */
    @JvmName("guykfhgysvcpntot")
    public suspend fun apiVersionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersionDescription = mapped
    }

    /**
     * @param value Version set details
     */
    @JvmName("udrxgxlggpwwxtjm")
    public suspend fun apiVersionSet(`value`: ApiVersionSetContractDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersionSet = mapped
    }

    /**
     * @param argument Version set details
     */
    @JvmName("thchwykjyeckchox")
    public suspend fun apiVersionSet(argument: suspend ApiVersionSetContractDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ApiVersionSetContractDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiVersionSet = mapped
    }

    /**
     * @param value A resource identifier for the related ApiVersionSet.
     */
    @JvmName("jjpfkrlifdsnujsf")
    public suspend fun apiVersionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersionSetId = mapped
    }

    /**
     * @param value Collection of authentication settings included into this API.
     */
    @JvmName("staifmmtimintvdh")
    public suspend fun authenticationSettings(`value`: AuthenticationSettingsContractArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationSettings = mapped
    }

    /**
     * @param argument Collection of authentication settings included into this API.
     */
    @JvmName("hyrvwvoibxjskotd")
    public suspend fun authenticationSettings(argument: suspend AuthenticationSettingsContractArgsBuilder.() -> Unit) {
        val toBeMapped = AuthenticationSettingsContractArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authenticationSettings = mapped
    }

    /**
     * @param value Contact information for the API.
     */
    @JvmName("etybbfaimkveaedo")
    public suspend fun contact(`value`: ApiContactInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contact = mapped
    }

    /**
     * @param argument Contact information for the API.
     */
    @JvmName("rupogscrcllitugi")
    public suspend fun contact(argument: suspend ApiContactInformationArgsBuilder.() -> Unit) {
        val toBeMapped = ApiContactInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contact = mapped
    }

    /**
     * @param value Description of the API. May include HTML formatting tags.
     */
    @JvmName("awrqfijilpgalvyb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value API name. Must be 1 to 300 characters long.
     */
    @JvmName("lbwrtlwxbckakykb")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Format of the Content in which the API is getting imported.
     */
    @JvmName("kjlfmwjoaqfkpxxj")
    public suspend fun format(`value`: Either<String, ContentFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the Content in which the API is getting imported.
     */
    @JvmName("wudsuviqhuelbjwh")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the Content in which the API is getting imported.
     */
    @JvmName("qhxmjsrkynlrcsor")
    public fun format(`value`: ContentFormat) {
        val toBeMapped = Either.ofRight<String, ContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Indicates if API revision is current api revision.
     */
    @JvmName("pcvydcfsfisndqvs")
    public suspend fun isCurrent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isCurrent = mapped
    }

    /**
     * @param value License information for the API.
     */
    @JvmName("wkcnxclcjwfgjpsp")
    public suspend fun license(`value`: ApiLicenseInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.license = mapped
    }

    /**
     * @param argument License information for the API.
     */
    @JvmName("ykfdhanhkmrqgddt")
    public suspend fun license(argument: suspend ApiLicenseInformationArgsBuilder.() -> Unit) {
        val toBeMapped = ApiLicenseInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.license = mapped
    }

    /**
     * @param value Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
     */
    @JvmName("gqjescxrphynlpck")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Describes on which protocols the operations in this API can be invoked.
     */
    @JvmName("ufdgglcjggobnsqb")
    public suspend fun protocols(`value`: List<Either<String, Protocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param values Describes on which protocols the operations in this API can be invoked.
     */
    @JvmName("xlmkuhftlsxyjyrg")
    public suspend fun protocols(vararg values: Either<String, Protocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pamxowgcwvyhqebl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("jdquhosqkiirbjxw")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
     */
    @JvmName("jkwijnbmctaafigi")
    public suspend fun serviceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUrl = mapped
    }

    /**
     * @param value Type of API to create.
     *  * `http` creates a REST API
     *  * `soap` creates a SOAP pass-through API
     *  * `websocket` creates websocket API
     *  * `graphql` creates GraphQL API.
     */
    @JvmName("vkukijenntxpxypa")
    public suspend fun soapApiType(`value`: Either<String, SoapApiType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.soapApiType = mapped
    }

    /**
     * @param value Type of API to create.
     *  * `http` creates a REST API
     *  * `soap` creates a SOAP pass-through API
     *  * `websocket` creates websocket API
     *  * `graphql` creates GraphQL API.
     */
    @JvmName("upgigqyxqircdgsv")
    public fun soapApiType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SoapApiType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.soapApiType = mapped
    }

    /**
     * @param value Type of API to create.
     *  * `http` creates a REST API
     *  * `soap` creates a SOAP pass-through API
     *  * `websocket` creates websocket API
     *  * `graphql` creates GraphQL API.
     */
    @JvmName("exgdwuhvjkmqvojs")
    public fun soapApiType(`value`: SoapApiType) {
        val toBeMapped = Either.ofRight<String, SoapApiType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.soapApiType = mapped
    }

    /**
     * @param value API identifier of the source API.
     */
    @JvmName("yivfgroqxfwehnhy")
    public suspend fun sourceApiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceApiId = mapped
    }

    /**
     * @param value Protocols over which API is made available.
     */
    @JvmName("vurvtmqjtinknxhs")
    public suspend fun subscriptionKeyParameterNames(`value`: SubscriptionKeyParameterNamesContractArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionKeyParameterNames = mapped
    }

    /**
     * @param argument Protocols over which API is made available.
     */
    @JvmName("gokumfxfmfvbufxw")
    public suspend fun subscriptionKeyParameterNames(argument: suspend SubscriptionKeyParameterNamesContractArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriptionKeyParameterNamesContractArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.subscriptionKeyParameterNames = mapped
    }

    /**
     * @param value Specifies whether an API or Product subscription is required for accessing the API.
     */
    @JvmName("tmshimndvanmeiwg")
    public suspend fun subscriptionRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionRequired = mapped
    }

    /**
     * @param value  A URL to the Terms of Service for the API. MUST be in the format of a URL.
     */
    @JvmName("vfnvasgkuyehkmrx")
    public suspend fun termsOfServiceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.termsOfServiceUrl = mapped
    }

    /**
     * @param value Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
     */
    @JvmName("uvomtbriyrbkkuyi")
    public suspend fun translateRequiredQueryParametersConduct(`value`: Either<String, TranslateRequiredQueryParametersConduct>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translateRequiredQueryParametersConduct = mapped
    }

    /**
     * @param value Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
     */
    @JvmName("oauiokorajomxona")
    public fun translateRequiredQueryParametersConduct(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TranslateRequiredQueryParametersConduct>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.translateRequiredQueryParametersConduct = mapped
    }

    /**
     * @param value Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template', 'query'
     */
    @JvmName("whiwxqtabdplheqn")
    public fun translateRequiredQueryParametersConduct(`value`: TranslateRequiredQueryParametersConduct) {
        val toBeMapped = Either.ofRight<String, TranslateRequiredQueryParametersConduct>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.translateRequiredQueryParametersConduct = mapped
    }

    /**
     * @param value Content value when Importing an API.
     */
    @JvmName("amxcjegcglvtspvi")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("txyrimcaenxncavj")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    /**
     * @param value Criteria to limit import of WSDL to a subset of the document.
     */
    @JvmName("hamgxmphwrjeeqqy")
    public suspend fun wsdlSelector(`value`: ApiCreateOrUpdatePropertiesWsdlSelectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wsdlSelector = mapped
    }

    /**
     * @param argument Criteria to limit import of WSDL to a subset of the document.
     */
    @JvmName("tmcwyduaicwrgtah")
    public suspend fun wsdlSelector(argument: suspend ApiCreateOrUpdatePropertiesWsdlSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = ApiCreateOrUpdatePropertiesWsdlSelectorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.wsdlSelector = mapped
    }

    internal fun build(): WorkspaceApiArgs = WorkspaceApiArgs(
        apiId = apiId,
        apiRevision = apiRevision,
        apiRevisionDescription = apiRevisionDescription,
        apiType = apiType,
        apiVersion = apiVersion,
        apiVersionDescription = apiVersionDescription,
        apiVersionSet = apiVersionSet,
        apiVersionSetId = apiVersionSetId,
        authenticationSettings = authenticationSettings,
        contact = contact,
        description = description,
        displayName = displayName,
        format = format,
        isCurrent = isCurrent,
        license = license,
        path = path,
        protocols = protocols,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        serviceUrl = serviceUrl,
        soapApiType = soapApiType,
        sourceApiId = sourceApiId,
        subscriptionKeyParameterNames = subscriptionKeyParameterNames,
        subscriptionRequired = subscriptionRequired,
        termsOfServiceUrl = termsOfServiceUrl,
        translateRequiredQueryParametersConduct = translateRequiredQueryParametersConduct,
        `value` = `value`,
        workspaceId = workspaceId,
        wsdlSelector = wsdlSelector,
    )
}
