@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterContractResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.RequestContractResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ResponseContractResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ParameterContractResponse.Companion.toKotlin as parameterContractResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.RequestContractResponse.Companion.toKotlin as requestContractResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ResponseContractResponse.Companion.toKotlin as responseContractResponseToKotlin

/**
 * Builder for [WorkspaceApiOperation].
 */
@PulumiTagMarker
public class WorkspaceApiOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceApiOperationArgs = WorkspaceApiOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceApiOperationArgsBuilder.() -> Unit) {
        val builder = WorkspaceApiOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceApiOperation {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.WorkspaceApiOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceApiOperation(builtJavaResource)
    }
}

/**
 * API Operation details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceApiOperation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceApiOperation = new AzureNative.ApiManagement.WorkspaceApiOperation("workspaceApiOperation", new()
 *     {
 *         ApiId = "PetStoreTemplate2",
 *         Description = "This can only be done by the logged in user.",
 *         DisplayName = "createUser2",
 *         Method = "POST",
 *         OperationId = "newoperations",
 *         Request = new AzureNative.ApiManagement.Inputs.RequestContractArgs
 *         {
 *             Description = "Created user object",
 *             Headers = new() { },
 *             QueryParameters = new() { },
 *             Representations = new[]
 *             {
 *                 new AzureNative.ApiManagement.Inputs.RepresentationContractArgs
 *                 {
 *                     ContentType = "application/json",
 *                     SchemaId = "592f6c1d0af5840ca8897f0c",
 *                     TypeName = "User",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Responses = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.ResponseContractArgs
 *             {
 *                 Description = "successful operation",
 *                 Headers = new() { },
 *                 Representations = new[]
 *                 {
 *                     new AzureNative.ApiManagement.Inputs.RepresentationContractArgs
 *                     {
 *                         ContentType = "application/xml",
 *                     },
 *                     new AzureNative.ApiManagement.Inputs.RepresentationContractArgs
 *                     {
 *                         ContentType = "application/json",
 *                     },
 *                 },
 *                 StatusCode = 200,
 *             },
 *         },
 *         ServiceName = "apimService1",
 *         TemplateParameters = new[] {},
 *         UrlTemplate = "/user1",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceApiOperation(ctx, "workspaceApiOperation", &apimanagement.WorkspaceApiOperationArgs{
 * 			ApiId:       pulumi.String("PetStoreTemplate2"),
 * 			Description: pulumi.String("This can only be done by the logged in user."),
 * 			DisplayName: pulumi.String("createUser2"),
 * 			Method:      pulumi.String("POST"),
 * 			OperationId: pulumi.String("newoperations"),
 * 			Request: &apimanagement.RequestContractArgs{
 * 				Description:     pulumi.String("Created user object"),
 * 				Headers:         apimanagement.ParameterContractArray{},
 * 				QueryParameters: apimanagement.ParameterContractArray{},
 * 				Representations: apimanagement.RepresentationContractArray{
 * 					&apimanagement.RepresentationContractArgs{
 * 						ContentType: pulumi.String("application/json"),
 * 						SchemaId:    pulumi.String("592f6c1d0af5840ca8897f0c"),
 * 						TypeName:    pulumi.String("User"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Responses: apimanagement.ResponseContractArray{
 * 				&apimanagement.ResponseContractArgs{
 * 					Description: pulumi.String("successful operation"),
 * 					Headers:     apimanagement.ParameterContractArray{},
 * 					Representations: apimanagement.RepresentationContractArray{
 * 						&apimanagement.RepresentationContractArgs{
 * 							ContentType: pulumi.String("application/xml"),
 * 						},
 * 						&apimanagement.RepresentationContractArgs{
 * 							ContentType: pulumi.String("application/json"),
 * 						},
 * 					},
 * 					StatusCode: pulumi.Int(200),
 * 				},
 * 			},
 * 			ServiceName:        pulumi.String("apimService1"),
 * 			TemplateParameters: apimanagement.ParameterContractArray{},
 * 			UrlTemplate:        pulumi.String("/user1"),
 * 			WorkspaceId:        pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceApiOperation;
 * import com.pulumi.azurenative.apimanagement.WorkspaceApiOperationArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.RequestContractArgs;
 * import com.pulumi.azurenative.apimanagement.inputs.ResponseContractArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceApiOperation = new WorkspaceApiOperation("workspaceApiOperation", WorkspaceApiOperationArgs.builder()
 *             .apiId("PetStoreTemplate2")
 *             .description("This can only be done by the logged in user.")
 *             .displayName("createUser2")
 *             .method("POST")
 *             .operationId("newoperations")
 *             .request(RequestContractArgs.builder()
 *                 .description("Created user object")
 *                 .headers()
 *                 .queryParameters()
 *                 .representations(RepresentationContractArgs.builder()
 *                     .contentType("application/json")
 *                     .schemaId("592f6c1d0af5840ca8897f0c")
 *                     .typeName("User")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .responses(ResponseContractArgs.builder()
 *                 .description("successful operation")
 *                 .headers()
 *                 .representations(
 *                     RepresentationContractArgs.builder()
 *                         .contentType("application/xml")
 *                         .build(),
 *                     RepresentationContractArgs.builder()
 *                         .contentType("application/json")
 *                         .build())
 *                 .statusCode(200)
 *                 .build())
 *             .serviceName("apimService1")
 *             .templateParameters()
 *             .urlTemplate("/user1")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceApiOperation newoperations /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis/{apiId}/operations/{operationId}
 * ```
 */
public class WorkspaceApiOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.WorkspaceApiOperation,
) : KotlinCustomResource(javaResource, WorkspaceApiOperationMapper) {
    /**
     * Description of the operation. May include HTML formatting tags.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Operation Name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
     */
    public val method: Output<String>
        get() = javaResource.method().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operation Policies
     */
    public val policies: Output<String>?
        get() = javaResource.policies().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An entity containing request details.
     */
    public val request: Output<RequestContractResponse>?
        get() = javaResource.request().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    requestContractResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Array of Operation responses.
     */
    public val responses: Output<List<ResponseContractResponse>>?
        get() = javaResource.responses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> responseContractResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Collection of URL template parameters.
     */
    public val templateParameters: Output<List<ParameterContractResponse>>?
        get() = javaResource.templateParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        parameterContractResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
     */
    public val urlTemplate: Output<String>
        get() = javaResource.urlTemplate().applyValue({ args0 -> args0 })
}

public object WorkspaceApiOperationMapper : ResourceMapper<WorkspaceApiOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.WorkspaceApiOperation::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceApiOperation =
        WorkspaceApiOperation(
            javaResource as
                com.pulumi.azurenative.apimanagement.WorkspaceApiOperation,
        )
}

/**
 * @see [WorkspaceApiOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceApiOperation].
 */
public suspend fun workspaceApiOperation(
    name: String,
    block: suspend WorkspaceApiOperationResourceBuilder.() -> Unit,
): WorkspaceApiOperation {
    val builder = WorkspaceApiOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceApiOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceApiOperation(name: String): WorkspaceApiOperation {
    val builder = WorkspaceApiOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
