@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceApiSchema].
 */
@PulumiTagMarker
public class WorkspaceApiSchemaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceApiSchemaArgs = WorkspaceApiSchemaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceApiSchemaArgsBuilder.() -> Unit) {
        val builder = WorkspaceApiSchemaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceApiSchema {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.WorkspaceApiSchema(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceApiSchema(builtJavaResource)
    }
}

/**
 * API Schema Contract details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceApiSchema
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceApiSchema = new AzureNative.ApiManagement.WorkspaceApiSchema("workspaceApiSchema", new()
 *     {
 *         ApiId = "59d6bb8f1f7fab13dc67ec9b",
 *         ContentType = "application/vnd.ms-azure-apim.xsd+xml",
 *         ResourceGroupName = "rg1",
 *         SchemaId = "ec12520d-9d48-4e7b-8f39-698ca2ac63f1",
 *         ServiceName = "apimService1",
 *         Value = @"<s:schema elementFormDefault=""qualified"" targetNamespace=""http://ws.cdyne.com/WeatherWS/"" xmlns:tns=""http://ws.cdyne.com/WeatherWS/"" xmlns:s=""http://www.w3.org/2001/XMLSchema"" xmlns:soap12=""http://schemas.xmlsoap.org/wsdl/soap12/"" xmlns:mime=""http://schemas.xmlsoap.org/wsdl/mime/"" xmlns:soap=""http://schemas.xmlsoap.org/wsdl/soap/"" xmlns:tm=""http://microsoft.com/wsdl/mime/textMatching/"" xmlns:http=""http://schemas.xmlsoap.org/wsdl/http/"" xmlns:soapenc=""http://schemas.xmlsoap.org/soap/encoding/"" xmlns:wsdl=""http://schemas.xmlsoap.org/wsdl/"" xmlns:apim-wsdltns=""http://ws.cdyne.com/WeatherWS/"">
 *   <s:element name=""GetWeatherInformation"">
 *     <s:complexType />
 *   </s:element>
 *   <s:element name=""GetWeatherInformationResponse"">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs=""0"" maxOccurs=""1"" name=""GetWeatherInformationResult"" type=""tns:ArrayOfWeatherDescription"" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name=""ArrayOfWeatherDescription"">
 *     <s:sequence>
 *       <s:element minOccurs=""0"" maxOccurs=""unbounded"" name=""WeatherDescription"" type=""tns:WeatherDescription"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name=""WeatherDescription"">
 *     <s:sequence>
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""WeatherID"" type=""s:short"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Description"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""PictureURL"" type=""s:string"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name=""GetCityForecastByZIP"">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs=""0"" maxOccurs=""1"" name=""ZIP"" type=""s:string"" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name=""GetCityForecastByZIPResponse"">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs=""0"" maxOccurs=""1"" name=""GetCityForecastByZIPResult"" type=""tns:ForecastReturn"" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name=""ForecastReturn"">
 *     <s:sequence>
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""Success"" type=""s:boolean"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""ResponseText"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""State"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""City"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""WeatherStationCity"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""ForecastResult"" type=""tns:ArrayOfForecast"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name=""ArrayOfForecast"">
 *     <s:sequence>
 *       <s:element minOccurs=""0"" maxOccurs=""unbounded"" name=""Forecast"" nillable=""true"" type=""tns:Forecast"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name=""Forecast"">
 *     <s:sequence>
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""Date"" type=""s:dateTime"" />
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""WeatherID"" type=""s:short"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Desciption"" type=""s:string"" />
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""Temperatures"" type=""tns:temp"" />
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""ProbabilityOfPrecipiation"" type=""tns:POP"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name=""temp"">
 *     <s:sequence>
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""MorningLow"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""DaytimeHigh"" type=""s:string"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name=""POP"">
 *     <s:sequence>
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Nighttime"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Daytime"" type=""s:string"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name=""GetCityWeatherByZIP"">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs=""0"" maxOccurs=""1"" name=""ZIP"" type=""s:string"" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name=""GetCityWeatherByZIPResponse"">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs=""1"" maxOccurs=""1"" name=""GetCityWeatherByZIPResult"" type=""tns:WeatherReturn"" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name=""WeatherReturn"">
 *     <s:sequence>
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""Success"" type=""s:boolean"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""ResponseText"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""State"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""City"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""WeatherStationCity"" type=""s:string"" />
 *       <s:element minOccurs=""1"" maxOccurs=""1"" name=""WeatherID"" type=""s:short"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Description"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Temperature"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""RelativeHumidity"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Wind"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Pressure"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Visibility"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""WindChill"" type=""s:string"" />
 *       <s:element minOccurs=""0"" maxOccurs=""1"" name=""Remarks"" type=""s:string"" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name=""ArrayOfWeatherDescription"" nillable=""true"" type=""tns:ArrayOfWeatherDescription"" />
 *   <s:element name=""ForecastReturn"" nillable=""true"" type=""tns:ForecastReturn"" />
 *   <s:element name=""WeatherReturn"" type=""tns:WeatherReturn"" />
 * </s:schema>",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceApiSchema(ctx, "workspaceApiSchema", &apimanagement.WorkspaceApiSchemaArgs{
 * 			ApiId:             pulumi.String("59d6bb8f1f7fab13dc67ec9b"),
 * 			ContentType:       pulumi.String("application/vnd.ms-azure-apim.xsd+xml"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SchemaId:          pulumi.String("ec12520d-9d48-4e7b-8f39-698ca2ac63f1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.String(`<s:schema elementFormDefault="qualified" targetNamespace="http://ws.cdyne.com/WeatherWS/" xmlns:tns="http://ws.cdyne.com/WeatherWS/" xmlns:s="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://schemas.xmlsoap.org/wsdl/soap12/" xmlns:mime="http://schemas.xmlsoap.org/wsdl/mime/" xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/" xmlns:tm="http://microsoft.com/wsdl/mime/textMatching/" xmlns:http="http://schemas.xmlsoap.org/wsdl/http/" xmlns:soapenc="http://schemas.xmlsoap.org/soap/encoding/" xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/" xmlns:apim-wsdltns="http://ws.cdyne.com/WeatherWS/">
 *   <s:element name="GetWeatherInformation">
 *     <s:complexType />
 *   </s:element>
 *   <s:element name="GetWeatherInformationResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="GetWeatherInformationResult" type="tns:ArrayOfWeatherDescription" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="ArrayOfWeatherDescription">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="unbounded" name="WeatherDescription" type="tns:WeatherDescription" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="WeatherDescription">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Description" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="PictureURL" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="GetCityForecastByZIP">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="ZIP" type="s:string" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name="GetCityForecastByZIPResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="GetCityForecastByZIPResult" type="tns:ForecastReturn" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="ForecastReturn">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Success" type="s:boolean" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ResponseText" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="State" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="City" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WeatherStationCity" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ForecastResult" type="tns:ArrayOfForecast" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="ArrayOfForecast">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="unbounded" name="Forecast" nillable="true" type="tns:Forecast" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="Forecast">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Date" type="s:dateTime" />
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Desciption" type="s:string" />
 *       <s:element minOccurs="1" maxOccurs="1" name="Temperatures" type="tns:temp" />
 *       <s:element minOccurs="1" maxOccurs="1" name="ProbabilityOfPrecipiation" type="tns:POP" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="temp">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="1" name="MorningLow" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="DaytimeHigh" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="POP">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="1" name="Nighttime" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Daytime" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="GetCityWeatherByZIP">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="ZIP" type="s:string" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name="GetCityWeatherByZIPResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="1" maxOccurs="1" name="GetCityWeatherByZIPResult" type="tns:WeatherReturn" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="WeatherReturn">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Success" type="s:boolean" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ResponseText" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="State" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="City" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WeatherStationCity" type="s:string" />
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Description" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Temperature" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="RelativeHumidity" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Wind" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Pressure" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Visibility" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WindChill" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Remarks" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="ArrayOfWeatherDescription" nillable="true" type="tns:ArrayOfWeatherDescription" />
 *   <s:element name="ForecastReturn" nillable="true" type="tns:ForecastReturn" />
 *   <s:element name="WeatherReturn" type="tns:WeatherReturn" />
 * </s:schema>`),
 * 			WorkspaceId: pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceApiSchema;
 * import com.pulumi.azurenative.apimanagement.WorkspaceApiSchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceApiSchema = new WorkspaceApiSchema("workspaceApiSchema", WorkspaceApiSchemaArgs.builder()
 *             .apiId("59d6bb8f1f7fab13dc67ec9b")
 *             .contentType("application/vnd.ms-azure-apim.xsd+xml")
 *             .resourceGroupName("rg1")
 *             .schemaId("ec12520d-9d48-4e7b-8f39-698ca2ac63f1")
 *             .serviceName("apimService1")
 *             .value("""
 * <s:schema elementFormDefault="qualified" targetNamespace="http://ws.cdyne.com/WeatherWS/" xmlns:tns="http://ws.cdyne.com/WeatherWS/" xmlns:s="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://schemas.xmlsoap.org/wsdl/soap12/" xmlns:mime="http://schemas.xmlsoap.org/wsdl/mime/" xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/" xmlns:tm="http://microsoft.com/wsdl/mime/textMatching/" xmlns:http="http://schemas.xmlsoap.org/wsdl/http/" xmlns:soapenc="http://schemas.xmlsoap.org/soap/encoding/" xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/" xmlns:apim-wsdltns="http://ws.cdyne.com/WeatherWS/">
 *   <s:element name="GetWeatherInformation">
 *     <s:complexType />
 *   </s:element>
 *   <s:element name="GetWeatherInformationResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="GetWeatherInformationResult" type="tns:ArrayOfWeatherDescription" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="ArrayOfWeatherDescription">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="unbounded" name="WeatherDescription" type="tns:WeatherDescription" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="WeatherDescription">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Description" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="PictureURL" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="GetCityForecastByZIP">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="ZIP" type="s:string" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name="GetCityForecastByZIPResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="GetCityForecastByZIPResult" type="tns:ForecastReturn" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="ForecastReturn">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Success" type="s:boolean" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ResponseText" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="State" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="City" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WeatherStationCity" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ForecastResult" type="tns:ArrayOfForecast" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="ArrayOfForecast">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="unbounded" name="Forecast" nillable="true" type="tns:Forecast" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="Forecast">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Date" type="s:dateTime" />
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Desciption" type="s:string" />
 *       <s:element minOccurs="1" maxOccurs="1" name="Temperatures" type="tns:temp" />
 *       <s:element minOccurs="1" maxOccurs="1" name="ProbabilityOfPrecipiation" type="tns:POP" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="temp">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="1" name="MorningLow" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="DaytimeHigh" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:complexType name="POP">
 *     <s:sequence>
 *       <s:element minOccurs="0" maxOccurs="1" name="Nighttime" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Daytime" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="GetCityWeatherByZIP">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="0" maxOccurs="1" name="ZIP" type="s:string" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:element name="GetCityWeatherByZIPResponse">
 *     <s:complexType>
 *       <s:sequence>
 *         <s:element minOccurs="1" maxOccurs="1" name="GetCityWeatherByZIPResult" type="tns:WeatherReturn" />
 *       </s:sequence>
 *     </s:complexType>
 *   </s:element>
 *   <s:complexType name="WeatherReturn">
 *     <s:sequence>
 *       <s:element minOccurs="1" maxOccurs="1" name="Success" type="s:boolean" />
 *       <s:element minOccurs="0" maxOccurs="1" name="ResponseText" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="State" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="City" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WeatherStationCity" type="s:string" />
 *       <s:element minOccurs="1" maxOccurs="1" name="WeatherID" type="s:short" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Description" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Temperature" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="RelativeHumidity" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Wind" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Pressure" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Visibility" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="WindChill" type="s:string" />
 *       <s:element minOccurs="0" maxOccurs="1" name="Remarks" type="s:string" />
 *     </s:sequence>
 *   </s:complexType>
 *   <s:element name="ArrayOfWeatherDescription" nillable="true" type="tns:ArrayOfWeatherDescription" />
 *   <s:element name="ForecastReturn" nillable="true" type="tns:ForecastReturn" />
 *   <s:element name="WeatherReturn" type="tns:WeatherReturn" />
 * </s:schema>            """)
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceApiSchema ec12520d-9d48-4e7b-8f39-698ca2ac63f1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/apis/{apiId}/schemas/{schemaId}
 * ```
 */
public class WorkspaceApiSchema internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.WorkspaceApiSchema,
) : KotlinCustomResource(javaResource, WorkspaceApiSchemaMapper) {
    /**
     * Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
     */
    public val components: Output<Any>?
        get() = javaResource.components().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema document (e.g. application/json, application/xml). </br> - `Swagger` Schema use `application/vnd.ms-azure-apim.swagger.definitions+json` </br> - `WSDL` Schema use `application/vnd.ms-azure-apim.xsd+xml` </br> - `OpenApi` Schema use `application/vnd.oai.openapi.components+json` </br> - `WADL Schema` use `application/vnd.ms-azure-apim.wadl.grammars+xml`.
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
     */
    public val definitions: Output<Any>?
        get() = javaResource.definitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Json escaped string defining the document representing the Schema. Used for schemas other than Swagger/OpenAPI.
     */
    public val `value`: Output<String>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object WorkspaceApiSchemaMapper : ResourceMapper<WorkspaceApiSchema> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.WorkspaceApiSchema::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceApiSchema = WorkspaceApiSchema(
        javaResource as
            com.pulumi.azurenative.apimanagement.WorkspaceApiSchema,
    )
}

/**
 * @see [WorkspaceApiSchema].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceApiSchema].
 */
public suspend fun workspaceApiSchema(
    name: String,
    block: suspend WorkspaceApiSchemaResourceBuilder.() -> Unit,
): WorkspaceApiSchema {
    val builder = WorkspaceApiSchemaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceApiSchema].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceApiSchema(name: String): WorkspaceApiSchema {
    val builder = WorkspaceApiSchemaResourceBuilder()
    builder.name(name)
    return builder.build()
}
