@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspacePolicyArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.PolicyContentFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy Contract details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspacePolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspacePolicy = new AzureNative.ApiManagement.WorkspacePolicy("workspacePolicy", new()
 *     {
 *         Format = AzureNative.ApiManagement.PolicyContentFormat.Xml,
 *         PolicyId = "policy",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspacePolicy(ctx, "workspacePolicy", &apimanagement.WorkspacePolicyArgs{
 * 			Format:            pulumi.String(apimanagement.PolicyContentFormatXml),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicy;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspacePolicy = new WorkspacePolicy("workspacePolicy", WorkspacePolicyArgs.builder()
 *             .format("xml")
 *             .policyId("policy")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("<policies> <inbound /> <backend>    <forward-request />  </backend>  <outbound /></policies>")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateWorkspacePolicyNonXmlEncoded
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspacePolicy = new AzureNative.ApiManagement.WorkspacePolicy("workspacePolicy", new()
 *     {
 *         Format = AzureNative.ApiManagement.PolicyContentFormat.Rawxml,
 *         PolicyId = "policy",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = @"<policies>
 *      <inbound>
 *      <base />
 *   <set-header name=""newvalue"" exists-action=""override"">
 *    <value>""@(context.Request.Headers.FirstOrDefault(h => h.Ke==""Via""))"" </value>
 *     </set-header>
 *   </inbound>
 *       </policies>",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspacePolicy(ctx, "workspacePolicy", &apimanagement.WorkspacePolicyArgs{
 * 			Format:            pulumi.String(apimanagement.PolicyContentFormatRawxml),
 * 			PolicyId:          pulumi.String("policy"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.String(`<policies>
 *      <inbound>
 *      <base />
 *   <set-header name="newvalue" exists-action="override">
 *    <value>"@(context.Request.Headers.FirstOrDefault(h => h.Ke=="Via"))" </value>
 *     </set-header>
 *   </inbound>
 *       </policies>`),
 * 			WorkspaceId: pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicy;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspacePolicy = new WorkspacePolicy("workspacePolicy", WorkspacePolicyArgs.builder()
 *             .format("rawxml")
 *             .policyId("policy")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("""
 * <policies>
 *      <inbound>
 *      <base />
 *   <set-header name="newvalue" exists-action="override">
 *    <value>"@(context.Request.Headers.FirstOrDefault(h => h.Ke=="Via"))" </value>
 *     </set-header>
 *   </inbound>
 *       </policies>            """)
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspacePolicy policy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/policies/{policyId}
 * ```
 * @property format Format of the policyContent.
 * @property policyId The identifier of the Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property value Contents of the Policy as defined by the format.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspacePolicyArgs(
    public val format: Output<Either<String, PolicyContentFormat>>? = null,
    public val policyId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspacePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspacePolicyArgs =
        com.pulumi.azurenative.apimanagement.WorkspacePolicyArgs.builder()
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspacePolicyArgs].
 */
@PulumiTagMarker
public class WorkspacePolicyArgsBuilder internal constructor() {
    private var format: Output<Either<String, PolicyContentFormat>>? = null

    private var policyId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var `value`: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("nodlvrqctwxccpav")
    public suspend fun format(`value`: Output<Either<String, PolicyContentFormat>>) {
        this.format = value
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("ojdvsqdikueqjfai")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rkhjayrntrwuotkn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("qpbixphoabbletwb")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Contents of the Policy as defined by the format.
     */
    @JvmName("sdsjkidkacqdjxsi")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("xlcujakjhtytwbuk")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("lsoplopdfmyvwica")
    public suspend fun format(`value`: Either<String, PolicyContentFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("yotaqqygjkmekijh")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Format of the policyContent.
     */
    @JvmName("xprqjidojxcenhsy")
    public fun format(`value`: PolicyContentFormat) {
        val toBeMapped = Either.ofRight<String, PolicyContentFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("pucvgdbbbvxfgvgt")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("onbvlemoqjjjlwlh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vudfqyvhawcdelst")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Contents of the Policy as defined by the format.
     */
    @JvmName("sojqbbcgqhcorlyt")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("lplhgmdnmmonfhre")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspacePolicyArgs = WorkspacePolicyArgs(
        format = format,
        policyId = policyId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        `value` = `value`,
        workspaceId = workspaceId,
    )
}
