@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspaceTagApiLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Tag-API link details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceTagApiLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceTagApiLink = new AzureNative.ApiManagement.WorkspaceTagApiLink("workspaceTagApiLink", new()
 *     {
 *         ApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/apis/echo-api",
 *         ApiLinkId = "link1",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TagId = "tag1",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceTagApiLink(ctx, "workspaceTagApiLink", &apimanagement.WorkspaceTagApiLinkArgs{
 * 			ApiId:             pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/apis/echo-api"),
 * 			ApiLinkId:         pulumi.String("link1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			TagId:             pulumi.String("tag1"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceTagApiLink;
 * import com.pulumi.azurenative.apimanagement.WorkspaceTagApiLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceTagApiLink = new WorkspaceTagApiLink("workspaceTagApiLink", WorkspaceTagApiLinkArgs.builder()
 *             .apiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/apis/echo-api")
 *             .apiLinkId("link1")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tagId("tag1")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceTagApiLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/tags/{tagId}/apiLinks/{apiLinkId}
 * ```
 * @property apiId Full resource Id of an API.
 * @property apiLinkId Tag-API link identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tagId Tag identifier. Must be unique in the current API Management service instance.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspaceTagApiLinkArgs(
    public val apiId: Output<String>? = null,
    public val apiLinkId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tagId: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspaceTagApiLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspaceTagApiLinkArgs =
        com.pulumi.azurenative.apimanagement.WorkspaceTagApiLinkArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .apiLinkId(apiLinkId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tagId(tagId?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceTagApiLinkArgs].
 */
@PulumiTagMarker
public class WorkspaceTagApiLinkArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var apiLinkId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tagId: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Full resource Id of an API.
     */
    @JvmName("yikvybadnpmxcppp")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Tag-API link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("qlfwyebuevhsvfgt")
    public suspend fun apiLinkId(`value`: Output<String>) {
        this.apiLinkId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jjmdviwnhohxyvaa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("lhueyjljkbbuuted")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("umlntffdbtcjetea")
    public suspend fun tagId(`value`: Output<String>) {
        this.tagId = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("bkveuwjehncmeuam")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Full resource Id of an API.
     */
    @JvmName("kvkgbutuvaaxovva")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Tag-API link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("fohfflvqblwawwhq")
    public suspend fun apiLinkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiLinkId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gtpqdtfdajeumrnm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("gcoigpxoegeemsep")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("dflufauvpmkohouc")
    public suspend fun tagId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagId = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("glxsnwcgvsaafbfh")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceTagApiLinkArgs = WorkspaceTagApiLinkArgs(
        apiId = apiId,
        apiLinkId = apiLinkId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        tagId = tagId,
        workspaceId = workspaceId,
    )
}
