@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies for what type of messages sampling settings should not apply.
 */
public enum class AlwaysLog(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.AlwaysLog,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.AlwaysLog> {
    /**
     * Always log all erroneous request regardless of sampling settings.
     */
    AllErrors(com.pulumi.azurenative.apimanagement.enums.AlwaysLog.AllErrors),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.AlwaysLog = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.AlwaysLog): AlwaysLog =
            AlwaysLog.values().first { it.javaValue == javaType }
    }
}
