@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of API.
 */
public enum class ApiType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.ApiType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.ApiType> {
    Http(com.pulumi.azurenative.apimanagement.enums.ApiType.Http),
    Soap(com.pulumi.azurenative.apimanagement.enums.ApiType.Soap),
    Websocket(com.pulumi.azurenative.apimanagement.enums.ApiType.Websocket),
    Graphql(com.pulumi.azurenative.apimanagement.enums.ApiType.Graphql),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.ApiType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.ApiType): ApiType =
            ApiType.values().first { it.javaValue == javaType }
    }
}
