@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Determines the type of confirmation e-mail that will be sent to the newly created user.
 */
public enum class Confirmation(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.Confirmation,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.Confirmation> {
    /**
     * Send an e-mail to the user confirming they have successfully signed up.
     */
    Signup(com.pulumi.azurenative.apimanagement.enums.Confirmation.Signup),

    /**
     * Send an e-mail inviting the user to sign-up and complete registration.
     */
    Invite(com.pulumi.azurenative.apimanagement.enums.Confirmation.Invite),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.Confirmation = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.Confirmation): Confirmation = Confirmation.values().first { it.javaValue == javaType }
    }
}
