@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Format of the Content in which the API is getting imported.
 */
public enum class ContentFormat(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.ContentFormat,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.ContentFormat> {
    /**
     * The contents are inline and Content type is a WADL document.
     */
    Wadlxml(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Wadlxml),

    /**
     * The WADL document is hosted on a publicly accessible internet address.
     */
    Wadllinkjson(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Wadllinkjson),

    /**
     * The contents are inline and Content Type is a OpenAPI 2.0 JSON Document.
     */
    Swaggerjson(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Swaggerjson),

    /**
     * The OpenAPI 2.0 JSON document is hosted on a publicly accessible internet address.
     */
    Swaggerlinkjson(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Swaggerlinkjson),

    /**
     * The contents are inline and the document is a WSDL/Soap document.
     */
    Wsdl(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Wsdl),

    /**
     * The WSDL document is hosted on a publicly accessible internet address.
     */
    Wsdllink(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Wsdllink),

    /**
     * The contents are inline and Content Type is a OpenAPI 3.0 YAML Document.
     */
    Openapi(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Openapi),

    /**
     * The contents are inline and Content Type is a OpenAPI 3.0 JSON Document.
     */
    Openapi_json(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Openapi_json),

    /**
     * The OpenAPI 3.0 YAML document is hosted on a publicly accessible internet address.
     */
    Openapilink(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Openapilink),

    /**
     * The OpenAPI 3.0 JSON document is hosted on a publicly accessible internet address.
     */
    Openapi_jsonlink(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Openapi_jsonlink),

    /**
     * The GraphQL API endpoint hosted on a publicly accessible internet address.
     */
    Graphqllink(com.pulumi.azurenative.apimanagement.enums.ContentFormat.Graphqllink),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.ContentFormat = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.ContentFormat): ContentFormat = ContentFormat.values().first { it.javaValue == javaType }
    }
}
