@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Sets correlation protocol to use for Application Insights diagnostics.
 */
public enum class HttpCorrelationProtocol(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.HttpCorrelationProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.HttpCorrelationProtocol> {
    /**
     * Do not read and inject correlation headers.
     */
    None(com.pulumi.azurenative.apimanagement.enums.HttpCorrelationProtocol.None),

    /**
     * Inject Request-Id and Request-Context headers with request correlation data. See https://github.com/dotnet/corefx/blob/master/src/System.Diagnostics.DiagnosticSource/src/HttpCorrelationProtocol.md.
     */
    Legacy(com.pulumi.azurenative.apimanagement.enums.HttpCorrelationProtocol.Legacy),

    /**
     * Inject Trace Context headers. See https://w3c.github.io/trace-context.
     */
    W3C(com.pulumi.azurenative.apimanagement.enums.HttpCorrelationProtocol.W3C),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.HttpCorrelationProtocol =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.HttpCorrelationProtocol): HttpCorrelationProtocol =
            HttpCorrelationProtocol.values().first { it.javaValue == javaType }
    }
}
