@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Logger type.
 */
public enum class LoggerType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.LoggerType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.LoggerType> {
    /**
     * Azure Event Hub as log destination.
     */
    AzureEventHub(com.pulumi.azurenative.apimanagement.enums.LoggerType.AzureEventHub),

    /**
     * Azure Application Insights as log destination.
     */
    ApplicationInsights(com.pulumi.azurenative.apimanagement.enums.LoggerType.ApplicationInsights),

    /**
     * Azure Monitor
     */
    AzureMonitor(com.pulumi.azurenative.apimanagement.enums.LoggerType.AzureMonitor),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.LoggerType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.LoggerType): LoggerType = LoggerType.values().first { it.javaValue == javaType }
    }
}
