@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Format of the policyContent.
 */
public enum class PolicyContentFormat(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.PolicyContentFormat,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.PolicyContentFormat> {
    /**
     * The contents are inline and Content type is an XML document.
     */
    Xml(com.pulumi.azurenative.apimanagement.enums.PolicyContentFormat.Xml),

    /**
     * The policy XML document is hosted on a HTTP endpoint accessible from the API Management service.
     */
    Xmllink(com.pulumi.azurenative.apimanagement.enums.PolicyContentFormat.Xmllink),

    /**
     * The contents are inline and Content type is a non XML encoded policy document.
     */
    Rawxml(com.pulumi.azurenative.apimanagement.enums.PolicyContentFormat.Rawxml),

    /**
     * The policy document is not XML encoded and is hosted on a HTTP endpoint accessible from the API Management service.
     */
    Rawxmllink(com.pulumi.azurenative.apimanagement.enums.PolicyContentFormat.Rawxmllink),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.PolicyContentFormat = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.PolicyContentFormat): PolicyContentFormat = PolicyContentFormat.values().first { it.javaValue == javaType }
    }
}
