@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished.
 */
public enum class ProductState(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.ProductState,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.ProductState> {
    NotPublished(com.pulumi.azurenative.apimanagement.enums.ProductState.NotPublished),
    Published(com.pulumi.azurenative.apimanagement.enums.ProductState.Published),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.ProductState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.ProductState): ProductState = ProductState.values().first { it.javaValue == javaType }
    }
}
