@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Status of the issue.
 */
public enum class State(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.State,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.State> {
    /**
     * The issue is proposed.
     */
    Proposed(com.pulumi.azurenative.apimanagement.enums.State.Proposed),

    /**
     * The issue is opened.
     */
    Open(com.pulumi.azurenative.apimanagement.enums.State.Open),

    /**
     * The issue was removed.
     */
    Removed(com.pulumi.azurenative.apimanagement.enums.State.Removed),

    /**
     * The issue is now resolved.
     */
    Resolved(com.pulumi.azurenative.apimanagement.enums.State.Resolved),

    /**
     * The issue was closed.
     */
    Closed(com.pulumi.azurenative.apimanagement.enums.State.Closed),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.State = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.State): State =
            State.values().first { it.javaValue == javaType }
    }
}
