@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Initial subscription state. If no value is specified, subscription is created with Submitted state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated.
 */
public enum class SubscriptionState(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.SubscriptionState,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.SubscriptionState> {
    Suspended(com.pulumi.azurenative.apimanagement.enums.SubscriptionState.Suspended),
    Active(com.pulumi.azurenative.apimanagement.enums.SubscriptionState.Active),
    Expired(com.pulumi.azurenative.apimanagement.enums.SubscriptionState.Expired),
    Submitted(com.pulumi.azurenative.apimanagement.enums.SubscriptionState.Submitted),
    Rejected(com.pulumi.azurenative.apimanagement.enums.SubscriptionState.Rejected),
    Cancelled(com.pulumi.azurenative.apimanagement.enums.SubscriptionState.Cancelled),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.SubscriptionState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.SubscriptionState): SubscriptionState = SubscriptionState.values().first { it.javaValue == javaType }
    }
}
