@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * An value that determines where the API Version identifier will be located in a HTTP request.
 */
public enum class VersioningScheme(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.VersioningScheme,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.VersioningScheme> {
    /**
     * The API Version is passed in a path segment.
     */
    Segment(com.pulumi.azurenative.apimanagement.enums.VersioningScheme.Segment),

    /**
     * The API Version is passed in a query parameter.
     */
    Query(com.pulumi.azurenative.apimanagement.enums.VersioningScheme.Query),

    /**
     * The API Version is passed in a HTTP header.
     */
    Header(com.pulumi.azurenative.apimanagement.enums.VersioningScheme.Header),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.VersioningScheme = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.VersioningScheme): VersioningScheme = VersioningScheme.values().first { it.javaValue == javaType }
    }
}
