@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
 */
public enum class VirtualNetworkType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.VirtualNetworkType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.VirtualNetworkType> {
    /**
     * The service is not part of any Virtual Network.
     */
    None(com.pulumi.azurenative.apimanagement.enums.VirtualNetworkType.None),

    /**
     * The service is part of Virtual Network and it is accessible from Internet.
     */
    External(com.pulumi.azurenative.apimanagement.enums.VirtualNetworkType.External),

    /**
     * The service is part of Virtual Network and it is only accessible from within the virtual network.
     */
    Internal(com.pulumi.azurenative.apimanagement.enums.VirtualNetworkType.Internal),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.VirtualNetworkType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.VirtualNetworkType): VirtualNetworkType = VirtualNetworkType.values().first { it.javaValue == javaType }
    }
}
