@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.BackendTlsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties controlling TLS Certificate Validation.
 * @property validateCertificateChain Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
 * @property validateCertificateName Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
 */
public data class BackendTlsPropertiesArgs(
    public val validateCertificateChain: Output<Boolean>? = null,
    public val validateCertificateName: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.BackendTlsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.BackendTlsPropertiesArgs =
        com.pulumi.azurenative.apimanagement.inputs.BackendTlsPropertiesArgs.builder()
            .validateCertificateChain(validateCertificateChain?.applyValue({ args0 -> args0 }))
            .validateCertificateName(validateCertificateName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendTlsPropertiesArgs].
 */
@PulumiTagMarker
public class BackendTlsPropertiesArgsBuilder internal constructor() {
    private var validateCertificateChain: Output<Boolean>? = null

    private var validateCertificateName: Output<Boolean>? = null

    /**
     * @param value Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
     */
    @JvmName("vhbsdsnfexsxrhaa")
    public suspend fun validateCertificateChain(`value`: Output<Boolean>) {
        this.validateCertificateChain = value
    }

    /**
     * @param value Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
     */
    @JvmName("kboiasvjktnvvybv")
    public suspend fun validateCertificateName(`value`: Output<Boolean>) {
        this.validateCertificateName = value
    }

    /**
     * @param value Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
     */
    @JvmName("adaiexdbyndjaefp")
    public suspend fun validateCertificateChain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateCertificateChain = mapped
    }

    /**
     * @param value Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
     */
    @JvmName("ambrjtvnqeswdusg")
    public suspend fun validateCertificateName(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateCertificateName = mapped
    }

    internal fun build(): BackendTlsPropertiesArgs = BackendTlsPropertiesArgs(
        validateCertificateChain = validateCertificateChain,
        validateCertificateName = validateCertificateName,
    )
}
