@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.BodyDiagnosticSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Body logging settings.
 * @property bytes Number of request body bytes to log.
 */
public data class BodyDiagnosticSettingsArgs(
    public val bytes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.BodyDiagnosticSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.BodyDiagnosticSettingsArgs =
        com.pulumi.azurenative.apimanagement.inputs.BodyDiagnosticSettingsArgs.builder()
            .bytes(bytes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BodyDiagnosticSettingsArgs].
 */
@PulumiTagMarker
public class BodyDiagnosticSettingsArgsBuilder internal constructor() {
    private var bytes: Output<Int>? = null

    /**
     * @param value Number of request body bytes to log.
     */
    @JvmName("puhvgofhyflfqdnu")
    public suspend fun bytes(`value`: Output<Int>) {
        this.bytes = value
    }

    /**
     * @param value Number of request body bytes to log.
     */
    @JvmName("omwopdbxemjwfqhw")
    public suspend fun bytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bytes = mapped
    }

    internal fun build(): BodyDiagnosticSettingsArgs = BodyDiagnosticSettingsArgs(
        bytes = bytes,
    )
}
