@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.CertificateInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SSL certificate information.
 * @property expiry Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property subject Subject of the certificate.
 * @property thumbprint Thumbprint of the certificate.
 */
public data class CertificateInformationArgs(
    public val expiry: Output<String>,
    public val subject: Output<String>,
    public val thumbprint: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.CertificateInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.CertificateInformationArgs =
        com.pulumi.azurenative.apimanagement.inputs.CertificateInformationArgs.builder()
            .expiry(expiry.applyValue({ args0 -> args0 }))
            .subject(subject.applyValue({ args0 -> args0 }))
            .thumbprint(thumbprint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateInformationArgs].
 */
@PulumiTagMarker
public class CertificateInformationArgsBuilder internal constructor() {
    private var expiry: Output<String>? = null

    private var subject: Output<String>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    @JvmName("bwckyikcgxmgpxyi")
    public suspend fun expiry(`value`: Output<String>) {
        this.expiry = value
    }

    /**
     * @param value Subject of the certificate.
     */
    @JvmName("ahkjgqlpqnkrwvco")
    public suspend fun subject(`value`: Output<String>) {
        this.subject = value
    }

    /**
     * @param value Thumbprint of the certificate.
     */
    @JvmName("abvhgwyvohaiulke")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     */
    @JvmName("mueqrnbirmwbgtxy")
    public suspend fun expiry(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expiry = mapped
    }

    /**
     * @param value Subject of the certificate.
     */
    @JvmName("fmapqubpalcjlyfe")
    public suspend fun subject(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subject = mapped
    }

    /**
     * @param value Thumbprint of the certificate.
     */
    @JvmName("rtxcorfdgohrvwhb")
    public suspend fun thumbprint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): CertificateInformationArgs = CertificateInformationArgs(
        expiry = expiry ?: throw PulumiNullFieldException("expiry"),
        subject = subject ?: throw PulumiNullFieldException("subject"),
        thumbprint = thumbprint ?: throw PulumiNullFieldException("thumbprint"),
    )
}
