@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.EmailTemplateParametersContractPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Email Template Parameter contract.
 * @property description Template parameter description.
 * @property name Template parameter name.
 * @property title Template parameter title.
 */
public data class EmailTemplateParametersContractPropertiesArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val title: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.EmailTemplateParametersContractPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.EmailTemplateParametersContractPropertiesArgs =
        com.pulumi.azurenative.apimanagement.inputs.EmailTemplateParametersContractPropertiesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EmailTemplateParametersContractPropertiesArgs].
 */
@PulumiTagMarker
public class EmailTemplateParametersContractPropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Template parameter description.
     */
    @JvmName("ffcexnlyqkdqncrk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Template parameter name.
     */
    @JvmName("uxclymjnuavbhllb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Template parameter title.
     */
    @JvmName("lviqknduayuemqon")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Template parameter description.
     */
    @JvmName("uvvfjccmyacniwxm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Template parameter name.
     */
    @JvmName("gljkgjdkbaqosqpv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Template parameter title.
     */
    @JvmName("jcomsujrhgxenija")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): EmailTemplateParametersContractPropertiesArgs =
        EmailTemplateParametersContractPropertiesArgs(
            description = description,
            name = name,
            title = title,
        )
}
