@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetApiIssueAttachmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API identifier. Must be unique in the current API Management service instance.
 * @property attachmentId Attachment identifier within an Issue. Must be unique in the current Issue.
 * @property issueId Issue identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetApiIssueAttachmentPlainArgs(
    public val apiId: String,
    public val attachmentId: String,
    public val issueId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetApiIssueAttachmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetApiIssueAttachmentPlainArgs = com.pulumi.azurenative.apimanagement.inputs.GetApiIssueAttachmentPlainArgs.builder()
        .apiId(apiId.let({ args0 -> args0 }))
        .attachmentId(attachmentId.let({ args0 -> args0 }))
        .issueId(issueId.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiIssueAttachmentPlainArgs].
 */
@PulumiTagMarker
public class GetApiIssueAttachmentPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var attachmentId: String? = null

    private var issueId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("boehwandqfcandfd")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value Attachment identifier within an Issue. Must be unique in the current Issue.
     */
    @JvmName("xuufuhaxjuaefgeo")
    public suspend fun attachmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attachmentId = mapped
    }

    /**
     * @param value Issue identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ngakggirrphnxfao")
    public suspend fun issueId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.issueId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("goxnteyonesvjtxc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("eyumacngsakqmqjx")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetApiIssueAttachmentPlainArgs = GetApiIssueAttachmentPlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        attachmentId = attachmentId ?: throw PulumiNullFieldException("attachmentId"),
        issueId = issueId ?: throw PulumiNullFieldException("issueId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
