@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetApiReleasePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiId API identifier. Must be unique in the current API Management service instance.
 * @property releaseId Release identifier within an API. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetApiReleasePlainArgs(
    public val apiId: String,
    public val releaseId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetApiReleasePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetApiReleasePlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetApiReleasePlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .releaseId(releaseId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiReleasePlainArgs].
 */
@PulumiTagMarker
public class GetApiReleasePlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var releaseId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("lgapjsvsgxufedow")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value Release identifier within an API. Must be unique in the current API Management service instance.
     */
    @JvmName("nslnywoyycewbpfi")
    public suspend fun releaseId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.releaseId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eskobcddcoidoudq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ltukhsbikgxtqsag")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetApiReleasePlainArgs = GetApiReleasePlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        releaseId = releaseId ?: throw PulumiNullFieldException("releaseId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
