@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetApiVersionSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property versionSetId Api Version Set identifier. Must be unique in the current API Management service instance.
 */
public data class GetApiVersionSetPlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val versionSetId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetApiVersionSetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetApiVersionSetPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetApiVersionSetPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .versionSetId(versionSetId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiVersionSetPlainArgs].
 */
@PulumiTagMarker
public class GetApiVersionSetPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var versionSetId: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nqchdbwmfewigcmx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("hmrijugdadsewkyu")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Api Version Set identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("axyxpcwnalmrgmtd")
    public suspend fun versionSetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.versionSetId = mapped
    }

    internal fun build(): GetApiVersionSetPlainArgs = GetApiVersionSetPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        versionSetId = versionSetId ?: throw PulumiNullFieldException("versionSetId"),
    )
}
