@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationProviderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationProviderId Identifier of the authorization provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetAuthorizationProviderPlainArgs(
    public val authorizationProviderId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationProviderPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationProviderPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetAuthorizationProviderPlainArgs.builder()
            .authorizationProviderId(authorizationProviderId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuthorizationProviderPlainArgs].
 */
@PulumiTagMarker
public class GetAuthorizationProviderPlainArgsBuilder internal constructor() {
    private var authorizationProviderId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Identifier of the authorization provider.
     */
    @JvmName("wxiybtrpcoknarhx")
    public suspend fun authorizationProviderId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationProviderId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ijxskxuhldquivbw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vjepbdofodifjhsm")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetAuthorizationProviderPlainArgs = GetAuthorizationProviderPlainArgs(
        authorizationProviderId = authorizationProviderId ?: throw
            PulumiNullFieldException("authorizationProviderId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
