@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetProductGroupLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupLinkId Product-Group link identifier. Must be unique in the current API Management service instance.
 * @property productId Product identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetProductGroupLinkPlainArgs(
    public val groupLinkId: String,
    public val productId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetProductGroupLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetProductGroupLinkPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetProductGroupLinkPlainArgs.builder()
            .groupLinkId(groupLinkId.let({ args0 -> args0 }))
            .productId(productId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProductGroupLinkPlainArgs].
 */
@PulumiTagMarker
public class GetProductGroupLinkPlainArgsBuilder internal constructor() {
    private var groupLinkId: String? = null

    private var productId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Product-Group link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ltmqhytmtjqsaynl")
    public suspend fun groupLinkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupLinkId = mapped
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("tcavxpxmrgdyjjbj")
    public suspend fun productId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wbhojrfqcetvfvat")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("bsruohufowfuibnx")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetProductGroupLinkPlainArgs = GetProductGroupLinkPlainArgs(
        groupLinkId = groupLinkId ?: throw PulumiNullFieldException("groupLinkId"),
        productId = productId ?: throw PulumiNullFieldException("productId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
