@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property sid Subscription entity Identifier. The entity represents the association between a user and a product in API Management.
 */
public data class GetSubscriptionPlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val sid: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetSubscriptionPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetSubscriptionPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .sid(sid.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetSubscriptionPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var sid: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rvujjjxkcghyviot")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("aajfynjljxwmwcce")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Subscription entity Identifier. The entity represents the association between a user and a product in API Management.
     */
    @JvmName("mapdqqhpjfxdyldw")
    public suspend fun sid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sid = mapped
    }

    internal fun build(): GetSubscriptionPlainArgs = GetSubscriptionPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        sid = sid ?: throw PulumiNullFieldException("sid"),
    )
}
