@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetTagOperationLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property operationLinkId Tag-operation link identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tagId Tag identifier. Must be unique in the current API Management service instance.
 */
public data class GetTagOperationLinkPlainArgs(
    public val operationLinkId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val tagId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetTagOperationLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetTagOperationLinkPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetTagOperationLinkPlainArgs.builder()
            .operationLinkId(operationLinkId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .tagId(tagId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTagOperationLinkPlainArgs].
 */
@PulumiTagMarker
public class GetTagOperationLinkPlainArgsBuilder internal constructor() {
    private var operationLinkId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var tagId: String? = null

    /**
     * @param value Tag-operation link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ewhprxsilvyfobcr")
    public suspend fun operationLinkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.operationLinkId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("myvwebqthhmbgxdq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("gvwyyrcoyistghfi")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("yhpnfueakmumfhxo")
    public suspend fun tagId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagId = mapped
    }

    internal fun build(): GetTagOperationLinkPlainArgs = GetTagOperationLinkPlainArgs(
        operationLinkId = operationLinkId ?: throw PulumiNullFieldException("operationLinkId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        tagId = tagId ?: throw PulumiNullFieldException("tagId"),
    )
}
