@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property userId User identifier. Must be unique in the current API Management service instance.
 */
public data class GetUserPlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val userId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetUserPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetUserPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetUserPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .userId(userId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPlainArgs].
 */
@PulumiTagMarker
public class GetUserPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var userId: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ecailktyjwbimojj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("rfpsbitjvwfncqud")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value User identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("tulrtekusnvbwugi")
    public suspend fun userId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userId = mapped
    }

    internal fun build(): GetUserPlainArgs = GetUserPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        userId = userId ?: throw PulumiNullFieldException("userId"),
    )
}
