@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupId Group identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class GetWorkspaceGroupPlainArgs(
    public val groupId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val workspaceId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceGroupPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceGroupPlainArgs.builder()
            .groupId(groupId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceGroupPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceGroupPlainArgsBuilder internal constructor() {
    private var groupId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var workspaceId: String? = null

    /**
     * @param value Group identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("efxxevapsndfmnlt")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gbnghwboxajkonrl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("msoepeqtkvwgybef")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("jaodfeomdvexnhha")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetWorkspaceGroupPlainArgs = GetWorkspaceGroupPlainArgs(
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
