@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetWorkspacePolicyFragmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property format Policy fragment content format.
 * @property id A resource identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class GetWorkspacePolicyFragmentPlainArgs(
    public val format: String? = null,
    public val id: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val workspaceId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetWorkspacePolicyFragmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetWorkspacePolicyFragmentPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspacePolicyFragmentPlainArgs.builder()
            .format(format?.let({ args0 -> args0 }))
            .id(id.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspacePolicyFragmentPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspacePolicyFragmentPlainArgsBuilder internal constructor() {
    private var format: String? = null

    private var id: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var workspaceId: String? = null

    /**
     * @param value Policy fragment content format.
     */
    @JvmName("sogkbgfudffwbbyq")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.format = mapped
    }

    /**
     * @param value A resource identifier.
     */
    @JvmName("wlogwssyyuuxtuqo")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xowtwoiwiigcibwe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("kbcoqjdwoqsvhmpn")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("xnsiafrlxqtxkppy")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetWorkspacePolicyFragmentPlainArgs = GetWorkspacePolicyFragmentPlainArgs(
        format = format,
        id = id ?: throw PulumiNullFieldException("id"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
