@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetWorkspacePolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property format Policy Export Format.
 * @property policyId The identifier of the Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class GetWorkspacePolicyPlainArgs(
    public val format: String? = null,
    public val policyId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val workspaceId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetWorkspacePolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetWorkspacePolicyPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspacePolicyPlainArgs.builder()
            .format(format?.let({ args0 -> args0 }))
            .policyId(policyId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspacePolicyPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspacePolicyPlainArgsBuilder internal constructor() {
    private var format: String? = null

    private var policyId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var workspaceId: String? = null

    /**
     * @param value Policy Export Format.
     */
    @JvmName("cjfhjxvhwffltnjd")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.format = mapped
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("mopcxiurrxjmdhlb")
    public suspend fun policyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vtxotmkvvktpluhk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("iorujxynmioabvfr")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("nyoxwfygocphfxvi")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetWorkspacePolicyPlainArgs = GetWorkspacePolicyPlainArgs(
        format = format,
        policyId = policyId ?: throw PulumiNullFieldException("policyId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
