@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceTagPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tagId Tag identifier. Must be unique in the current API Management service instance.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class GetWorkspaceTagPlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val tagId: String,
    public val workspaceId: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceTagPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceTagPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetWorkspaceTagPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .tagId(tagId.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceTagPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceTagPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var tagId: String? = null

    private var workspaceId: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("msmoomifiuofotqg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ficsrkkcrsbwuiaa")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ayswxmkgdsqnehin")
    public suspend fun tagId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagId = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("vayfxxdwksjendiq")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetWorkspaceTagPlainArgs = GetWorkspaceTagPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        tagId = tagId ?: throw PulumiNullFieldException("tagId"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
