@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.KeyVaultContractCreatePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Create keyVault contract details.
 * @property identityClientId Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault secret.
 * @property secretIdentifier Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires API Management service to be configured with aka.ms/apimmsi
 */
public data class KeyVaultContractCreatePropertiesArgs(
    public val identityClientId: Output<String>? = null,
    public val secretIdentifier: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.KeyVaultContractCreatePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.KeyVaultContractCreatePropertiesArgs =
        com.pulumi.azurenative.apimanagement.inputs.KeyVaultContractCreatePropertiesArgs.builder()
            .identityClientId(identityClientId?.applyValue({ args0 -> args0 }))
            .secretIdentifier(secretIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultContractCreatePropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultContractCreatePropertiesArgsBuilder internal constructor() {
    private var identityClientId: Output<String>? = null

    private var secretIdentifier: Output<String>? = null

    /**
     * @param value Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault secret.
     */
    @JvmName("kmmfoikrirpdawme")
    public suspend fun identityClientId(`value`: Output<String>) {
        this.identityClientId = value
    }

    /**
     * @param value Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires API Management service to be configured with aka.ms/apimmsi
     */
    @JvmName("yxxbkrpyfcspiwlv")
    public suspend fun secretIdentifier(`value`: Output<String>) {
        this.secretIdentifier = value
    }

    /**
     * @param value Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault secret.
     */
    @JvmName("meflqknnchabriqm")
    public suspend fun identityClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityClientId = mapped
    }

    /**
     * @param value Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires API Management service to be configured with aka.ms/apimmsi
     */
    @JvmName("usalyefjexiinetl")
    public suspend fun secretIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretIdentifier = mapped
    }

    internal fun build(): KeyVaultContractCreatePropertiesArgs = KeyVaultContractCreatePropertiesArgs(
        identityClientId = identityClientId,
        secretIdentifier = secretIdentifier,
    )
}
