@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ParameterExampleContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameter example.
 * @property description Long description for the example
 * @property externalValue A URL that points to the literal example
 * @property summary Short description for the example
 * @property value Example value. May be a primitive value, or an object.
 */
public data class ParameterExampleContractArgs(
    public val description: Output<String>? = null,
    public val externalValue: Output<String>? = null,
    public val summary: Output<String>? = null,
    public val `value`: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ParameterExampleContractArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.ParameterExampleContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.ParameterExampleContractArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .externalValue(externalValue?.applyValue({ args0 -> args0 }))
            .summary(summary?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParameterExampleContractArgs].
 */
@PulumiTagMarker
public class ParameterExampleContractArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var externalValue: Output<String>? = null

    private var summary: Output<String>? = null

    private var `value`: Output<Any>? = null

    /**
     * @param value Long description for the example
     */
    @JvmName("usqdiglvwdyilwor")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A URL that points to the literal example
     */
    @JvmName("voibihgcygtolnnv")
    public suspend fun externalValue(`value`: Output<String>) {
        this.externalValue = value
    }

    /**
     * @param value Short description for the example
     */
    @JvmName("yxaaqbxpmtvnqeio")
    public suspend fun summary(`value`: Output<String>) {
        this.summary = value
    }

    /**
     * @param value Example value. May be a primitive value, or an object.
     */
    @JvmName("uqvsvyrtkkjyyojl")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value Long description for the example
     */
    @JvmName("ebtgpxcwaqhdjysh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A URL that points to the literal example
     */
    @JvmName("wfbtidbttoekldhq")
    public suspend fun externalValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalValue = mapped
    }

    /**
     * @param value Short description for the example
     */
    @JvmName("myivvasdoeobxxpq")
    public suspend fun summary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.summary = mapped
    }

    /**
     * @param value Example value. May be a primitive value, or an object.
     */
    @JvmName("ovksmglhberntuec")
    public suspend fun `value`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ParameterExampleContractArgs = ParameterExampleContractArgs(
        description = description,
        externalValue = externalValue,
        summary = summary,
        `value` = `value`,
    )
}
