@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.RemotePrivateEndpointConnectionWrapperArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Remote Private Endpoint Connection resource.
 * @property id Private Endpoint connection resource id
 * @property name Private Endpoint Connection Name
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property type Private Endpoint Connection Resource Type
 */
public data class RemotePrivateEndpointConnectionWrapperArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.RemotePrivateEndpointConnectionWrapperArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.RemotePrivateEndpointConnectionWrapperArgs =
        com.pulumi.azurenative.apimanagement.inputs.RemotePrivateEndpointConnectionWrapperArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RemotePrivateEndpointConnectionWrapperArgs].
 */
@PulumiTagMarker
public class RemotePrivateEndpointConnectionWrapperArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value Private Endpoint connection resource id
     */
    @JvmName("lqfwgxlqangsclft")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Private Endpoint Connection Name
     */
    @JvmName("uepaubjnhykooasx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("rigfrcmkqprnenbt")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Private Endpoint Connection Resource Type
     */
    @JvmName("egikhtyloijnjdch")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Private Endpoint connection resource id
     */
    @JvmName("jymoqamdlehtcpnp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Private Endpoint Connection Name
     */
    @JvmName("dtfjqqylcjigsvcs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("udbjrlujcugvglxg")
    public suspend fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("eraovdyojmbnfwai")
    public suspend fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Private Endpoint Connection Resource Type
     */
    @JvmName("rnhjqshdawvwilrf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RemotePrivateEndpointConnectionWrapperArgs =
        RemotePrivateEndpointConnectionWrapperArgs(
            id = id,
            name = name,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState ?: throw
                PulumiNullFieldException("privateLinkServiceConnectionState"),
            type = type,
        )
}
