@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.RepresentationContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Operation request/response representation details.
 * @property contentType Specifies a registered or custom content type for this representation, e.g. application/xml.
 * @property examples Exampled defined for the representation.
 * @property formParameters Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
 * @property schemaId Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
 * @property typeName Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
 */
public data class RepresentationContractArgs(
    public val contentType: Output<String>,
    public val examples: Output<Map<String, ParameterExampleContractArgs>>? = null,
    public val formParameters: Output<List<ParameterContractArgs>>? = null,
    public val schemaId: Output<String>? = null,
    public val typeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.RepresentationContractArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.RepresentationContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.RepresentationContractArgs.builder()
            .contentType(contentType.applyValue({ args0 -> args0 }))
            .examples(
                examples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .formParameters(
                formParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .schemaId(schemaId?.applyValue({ args0 -> args0 }))
            .typeName(typeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepresentationContractArgs].
 */
@PulumiTagMarker
public class RepresentationContractArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var examples: Output<Map<String, ParameterExampleContractArgs>>? = null

    private var formParameters: Output<List<ParameterContractArgs>>? = null

    private var schemaId: Output<String>? = null

    private var typeName: Output<String>? = null

    /**
     * @param value Specifies a registered or custom content type for this representation, e.g. application/xml.
     */
    @JvmName("njaretujumeioabm")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Exampled defined for the representation.
     */
    @JvmName("tgloebmdqwimhmvt")
    public suspend fun examples(`value`: Output<Map<String, ParameterExampleContractArgs>>) {
        this.examples = value
    }

    /**
     * @param value Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
     */
    @JvmName("wiuefdhenfceiwpb")
    public suspend fun formParameters(`value`: Output<List<ParameterContractArgs>>) {
        this.formParameters = value
    }

    @JvmName("pkpeiaugwfgyatml")
    public suspend fun formParameters(vararg values: Output<ParameterContractArgs>) {
        this.formParameters = Output.all(values.asList())
    }

    /**
     * @param values Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
     */
    @JvmName("ayuhbdtaaxypehbq")
    public suspend fun formParameters(values: List<Output<ParameterContractArgs>>) {
        this.formParameters = Output.all(values)
    }

    /**
     * @param value Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
     */
    @JvmName("qudcxnfiiuprnfle")
    public suspend fun schemaId(`value`: Output<String>) {
        this.schemaId = value
    }

    /**
     * @param value Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
     */
    @JvmName("upngnlqcpslhrwoe")
    public suspend fun typeName(`value`: Output<String>) {
        this.typeName = value
    }

    /**
     * @param value Specifies a registered or custom content type for this representation, e.g. application/xml.
     */
    @JvmName("oakkyygumblbjgoh")
    public suspend fun contentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Exampled defined for the representation.
     */
    @JvmName("qihoewocvkbkilgq")
    public suspend fun examples(`value`: Map<String, ParameterExampleContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.examples = mapped
    }

    /**
     * @param argument Exampled defined for the representation.
     */
    @JvmName("dxfslfdxtbiqpwmb")
    public suspend fun examples(vararg argument: Pair<String, suspend ParameterExampleContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterExampleContractArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.examples = mapped
    }

    /**
     * @param values Exampled defined for the representation.
     */
    @JvmName("nuoquudnuybgnhrb")
    public fun examples(vararg values: Pair<String, ParameterExampleContractArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.examples = mapped
    }

    /**
     * @param value Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
     */
    @JvmName("fgvnwffbjvbpadpc")
    public suspend fun formParameters(`value`: List<ParameterContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.formParameters = mapped
    }

    /**
     * @param argument Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
     */
    @JvmName("deffajqkunxrcdao")
    public suspend fun formParameters(argument: List<suspend ParameterContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.formParameters = mapped
    }

    /**
     * @param argument Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
     */
    @JvmName("iuxrkosepoibposk")
    public suspend fun formParameters(vararg argument: suspend ParameterContractArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.formParameters = mapped
    }

    /**
     * @param argument Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
     */
    @JvmName("gjbgjomatmamperh")
    public suspend fun formParameters(argument: suspend ParameterContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ParameterContractArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.formParameters = mapped
    }

    /**
     * @param values Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
     */
    @JvmName("cyiuiuqvwqlmcrst")
    public suspend fun formParameters(vararg values: ParameterContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.formParameters = mapped
    }

    /**
     * @param value Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
     */
    @JvmName("argjwcophixsvxto")
    public suspend fun schemaId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaId = mapped
    }

    /**
     * @param value Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
     */
    @JvmName("yfxuakvvubrbmdxg")
    public suspend fun typeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeName = mapped
    }

    internal fun build(): RepresentationContractArgs = RepresentationContractArgs(
        contentType = contentType ?: throw PulumiNullFieldException("contentType"),
        examples = examples,
        formParameters = formParameters,
        schemaId = schemaId,
        typeName = typeName,
    )
}
