@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.SamplingSettingsArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.SamplingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sampling settings for Diagnostic.
 * @property percentage Rate of sampling for fixed-rate sampling.
 * @property samplingType Sampling type.
 */
public data class SamplingSettingsArgs(
    public val percentage: Output<Double>? = null,
    public val samplingType: Output<Either<String, SamplingType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.SamplingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.SamplingSettingsArgs =
        com.pulumi.azurenative.apimanagement.inputs.SamplingSettingsArgs.builder()
            .percentage(percentage?.applyValue({ args0 -> args0 }))
            .samplingType(
                samplingType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SamplingSettingsArgs].
 */
@PulumiTagMarker
public class SamplingSettingsArgsBuilder internal constructor() {
    private var percentage: Output<Double>? = null

    private var samplingType: Output<Either<String, SamplingType>>? = null

    /**
     * @param value Rate of sampling for fixed-rate sampling.
     */
    @JvmName("vteldmdlcercusqx")
    public suspend fun percentage(`value`: Output<Double>) {
        this.percentage = value
    }

    /**
     * @param value Sampling type.
     */
    @JvmName("athibqyvwbajabja")
    public suspend fun samplingType(`value`: Output<Either<String, SamplingType>>) {
        this.samplingType = value
    }

    /**
     * @param value Rate of sampling for fixed-rate sampling.
     */
    @JvmName("herkhljxhkyjdfpp")
    public suspend fun percentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentage = mapped
    }

    /**
     * @param value Sampling type.
     */
    @JvmName("uhdykykuecdhtksa")
    public suspend fun samplingType(`value`: Either<String, SamplingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samplingType = mapped
    }

    /**
     * @param value Sampling type.
     */
    @JvmName("ipuockduhhsrbqyv")
    public fun samplingType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SamplingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingType = mapped
    }

    /**
     * @param value Sampling type.
     */
    @JvmName("tmjjfealeludstch")
    public fun samplingType(`value`: SamplingType) {
        val toBeMapped = Either.ofRight<String, SamplingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.samplingType = mapped
    }

    internal fun build(): SamplingSettingsArgs = SamplingSettingsArgs(
        percentage = percentage,
        samplingType = samplingType,
    )
}
